<!DOCTYPE html>
<html lang="tr">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, user-scalable=no">
    <title><?php echo $__env->yieldContent('title'); ?> </title>
    <meta name="description" content="<?php echo $__env->yieldContent('description'); ?>">
    <link rel="shortcut icon" type="image/png" href="/uploads/site/favicon.png"/>
    <link rel="shortcut icon" type="image/x-icon" href="/uploads/site/favicon.ico"/>
    <link rel="apple-touch-icon" type="image/x-icon" href="/uploads/site/favicon.ico"/>
    <link rel="alternate" hreflang="tr" href="<?php echo e(URL::to('/')); ?>"/>

    <meta property="og:locale" content="<?php echo e(config('app.locale')); ?>_<?php echo e(strtoupper(config('app.locale'))); ?>"/>
    <meta property="og:type" content="website"/>
    <meta property="og:title" content="<?php echo $__env->yieldContent('title',config('app.name')); ?>"/>
    <meta property="og:description" content="<?php echo $__env->yieldContent('description'); ?>"/>
    <meta property="og:url" content="<?php echo e(url()->current()); ?>"/>
    <meta property="og:site_name" content="<?php echo $__env->yieldContent('title'); ?>"/>
    <meta property="og:image" content="<?php echo $__env->yieldContent('image', URL::to('/').'/themes/'.config('site_settings.themes_dir').'/img/common/logo.png'); ?>"/>


    <link rel="canonical" href="<?php echo $__env->yieldContent('canonical'); ?>"/>
    <style>
        .splash-screen {
            background: white;
            background-size: cover;
            height: 100%;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            justify-items: center;
            z-index: 155555;
            width: 100%;
            position: fixed;
            top: 0;
        }
    </style>
</head>
<body>
<!--Mobil Header-->
<!--Overlay-->
<section class="overlay"></section>
<!--Splash-->
<div class="splash-screen">
    <div class="splash-logo">
        <img src="/themes/<?php echo e(config('site_settings.themes_dir')); ?>/img/common/logo-mobile.png" width="150" title="Arat">
    </div>
</div>
<!--Splash Bitti-->
<?php echo $__env->make('/themes.'.config('site_settings.themes_dir').'.layouts.partials.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<!--Header Bitti-->
<?php echo $__env->yieldContent('content'); ?>

<?php echo $__env->make('/themes.'.config('site_settings.themes_dir').'.layouts.partials.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<!--Başa dön-->
<a href="#" class="back-to-top"><i class="fas fa-chevron-up"></i> </a>
<!--Başa dön bitti-->
</body>
<!--CSS-->
<link rel="stylesheet" href="/themes/<?php echo e(config('site_settings.themes_dir')); ?>/css/bootstrap.min.css">
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.2.0/css/all.css"
      integrity="sha384-hWVjflwFxL6sNzntih27bfxkr27PmbbK/iSvJ+a4+0owXq79v+lsFkW54bOGbiDQ" crossorigin="anonymous">
<link rel="stylesheet" href="/themes/<?php echo e(config('site_settings.themes_dir')); ?>/css/style.css">
<link rel="stylesheet" href="/themes/<?php echo e(config('site_settings.themes_dir')); ?>/css/responsive.css">
<!--CSS Bitti-->

<?php echo $__env->yieldContent('css'); ?>

<!--Js-->

<script src="/themes/<?php echo e(config('site_settings.themes_dir')); ?>/js/jquery-3.3.1.min.js"></script>
<script src="/themes/<?php echo e(config('site_settings.themes_dir')); ?>/js/bootstrap.bundle.min.js"></script>
<script src="/themes/<?php echo e(config('site_settings.themes_dir')); ?>/js/site.js"></script>
<!--Js Bitti-->

<?php echo $__env->yieldContent('js'); ?>

</html>



