<?php /*|--------------------------------------------------------------------------| Web Routes|--------------------------------------------------------------------------|| Here is where you can register web routes for your application. These| routes are loaded by the RouteServiceProvider within a group which| contains the "web" middleware group. Now create something great!|*/

Route::prefix('de')->group(function () {

    Auth::routes();

    // Adminpanel Rotaları
    Route::group(['prefix' => 'adtrpanel', 'namespace' => 'Adtrpanel'], function () {
        Route::redirect('/', '/adtrpanel/giris-yap');
        Route::match(['get', 'post'], '/giris-yap', 'LoginController@login')->name('adtrpanel.login');
        Route::get('/cikis-yap', 'LoginController@Logout')->name('adtrpanel.logout');
        Route::group(['middleware' => 'adtr'], function () {
            Route::get('/dashboard', 'AnasayfaController@index')->name('adtrpanel.anasayfa');
            Route::get('/aktar', 'AnasayfaController@aktar')->name('adtrpanel.aktar');

            //Site Ayar İşlemleri
            Route::group(['prefix' => 'site_ayarlari'], function () {
                Route::match(['get', 'post'], '/', 'SitesettingsController@index')->name('adtrpanel.siteayarlari');
                Route::get('/yeniayar', 'SitesettingsController@addNewSetting')->name('adtrpanel.siteayarlari.newsetting');
                Route::post('/kaydet{id?}', 'SitesettingsController@save')->name('adtrpanel.siteayarlari.save');
            });

            //Kullanici İşlemleri
            Route::group(['prefix' => 'kullaniciyonetimi'], function () {
                Route::match(['get', 'post'], '/', 'UserController@index')->name('adtrpanel.users');
                Route::get('/olustur', 'UserController@userForm')->name('adtrpanel.users.new');
                Route::get('/duzenle/{id}', 'UserController@userForm')->name('adtrpanel.users.edit');
                Route::post('/kaydet/{id?}', 'UserController@save')->name('adtrpanel.users.save');
                Route::get('/sil/{id}', 'UserController@delete')->name('adtrpanel.users.delete');
                Route::get('/gruplar', 'UserController@groups')->name('adtrpanel.usergroups');
                Route::get('/gruplar/olustur', 'UserController@groupsForm')->name('adtrpanel.usergroups.new');
                Route::get('/gruplar/duzenle/{id}', 'UserController@groupsForm')->name('adtrpanel.usergroups.edit');
                Route::post('/gruplar/kaydet/{id?}', 'UserController@groupsSave')->name('adtrpanel.usergroups.save');
                Route::get('/gruplar/sil/{id}', 'UserController@groupsDelete')->name('adtrpanel.usergroups.delete');
                Route::get('/grupyetkileri/{id}', 'UserController@groupsAuthEdit')->name('adtrpanel.usergroups.authedit');
                Route::post('/grupyetkileri/kaydet/{id}', 'UserController@groupsAuthKaydet')->name('adtrpanel.usergroups.authsave');
            });

            //Sayfa İşlemleri
            Route::group(['prefix' => 'pages'], function () {
                Route::match(['get', 'post'], '/', 'PageController@index')->name('adtrpanel.pages');
                Route::get('/olustur', 'PageController@pagesForm')->name('adtrpanel.pages.new');
                Route::get('/duzenle/{id}', 'PageController@pagesForm')->name('adtrpanel.pages.edit');
                Route::post('/kaydet/{id?}', 'PageController@save')->name('adtrpanel.pages.save');
                Route::get('/sil/{id}', 'PageController@delete')->name('adtrpanel.pages.delete');
                Route::get('/aktifet/{id}', 'PageController@activated')->name('adtrpanel.pages.activated');
                Route::get('/pasifet/{id}', 'PageController@deactivated')->name('adtrpanel.pages.deactivated');
            });

            //Haber İşlemleri
            Route::group(['prefix' => 'articles'], function () {
                Route::match(['get', 'post'], '/', 'ArticleController@index')->name('adtrpanel.articles');
                Route::get('/olustur', 'ArticleController@articleForm')->name('adtrpanel.articles.new');
                Route::get('/duzenle/{id}', 'ArticleController@articleForm')->name('adtrpanel.articles.edit');
                Route::post('/kaydet/{id?}', 'ArticleController@save')->name('adtrpanel.articles.save');
                Route::get('/sil/{id}', 'ArticleController@delete')->name('adtrpanel.articles.delete');
                Route::get('/aktifet/{id}', 'ArticleController@activated')->name('adtrpanel.articles.activated');
                Route::get('/pasifet/{id}', 'ArticleController@deactivated')->name('adtrpanel.articles.deactivated');
            });

            //Blog İşlemleri
            Route::group(['prefix' => 'blogs'], function () {
                Route::match(['get', 'post'], '/', 'BlogController@index')->name('adtrpanel.blogs');
                Route::get('/olustur', 'BlogController@blogForm')->name('adtrpanel.blogs.new');
                Route::get('/duzenle/{id}', 'BlogController@blogForm')->name('adtrpanel.blogs.edit');
                Route::post('/kaydet/{id?}', 'BlogController@save')->name('adtrpanel.blogs.save');
                Route::get('/sil/{id}', 'BlogController@delete')->name('adtrpanel.blogs.delete');
                Route::get('/aktifet/{id}', 'BlogController@activated')->name('adtrpanel.blogs.activated');
                Route::get('/pasifet/{id}', 'BlogController@deactivated')->name('adtrpanel.blogs.deactivated');
            });

            Route::group(['prefix' => 'randevu_yonetimi'], function () {
                Route::match(['get', 'post'], '/', 'AppointmentController@index')->name('adtrpanel.appointments');
                Route::get('/read', 'AppointmentController@read')->name('adtrpanel.appointments.read');
                Route::get('/subjects', 'AppointmentController@subjects')->name('adtrpanel.appointments.subjects');
                Route::get('/subadd/{id?}', 'AppointmentController@subadd')->name('adtrpanel.appointments.subjects.add');
                Route::post('/save/{id?}', 'AppointmentController@save')->name('adtrpanel.appointments.subjects.save');
                Route::get('/sil/{id}', 'AppointmentController@delete')->name('adtrpanel.appointments.delete');
                Route::get('/aktifet/{id}', 'AppointmentController@activated')->name('adtrpanel.appointments.activated');
                Route::get('/pasifet/{id}', 'AppointmentController@deactivated')->name('adtrpanel.appointments.deactivated');
                Route::get('/subaktifet/{id}', 'AppointmentController@sub_activated')->name('adtrpanel.appointments.subjects.activated');
                Route::get('/subpasifet/{id}', 'AppointmentController@sub_deactivated')->name('adtrpanel.appointments.subjects.deactivated');
                Route::get('/subsil/{id}', 'AppointmentController@sub_delete')->name('adtrpanel.appointments.subjects.delete');
            });

            //Slider İşlemleri
            Route::group(['prefix' => 'sliders'], function () {
                Route::match(['get', 'post'], '/', 'SliderController@index')->name('adtrpanel.sliders');
                Route::get('/olustur', 'SliderController@slidersForm')->name('adtrpanel.sliders.new');
                Route::get('/duzenle/{id}', 'SliderController@slidersForm')->name('adtrpanel.sliders.edit');
                Route::post('/kaydet/{id?}', 'SliderController@save')->name('adtrpanel.sliders.save');
                Route::get('/sil/{id}', 'SliderController@delete')->name('adtrpanel.sliders.delete');
                Route::get('/aktifet/{id}', 'SliderController@activated')->name('adtrpanel.sliders.activated');
                Route::get('/pasifet/{id}', 'SliderController@deactivated')->name('adtrpanel.sliders.deactivated');
            });

            // SSS Yönetimi
            Route::group(['prefix' => 'sss_yonetimi'], function() {
                Route::match(['get', 'post'],'/', 'SssController@index')->name('adtrpanel.sss');
                Route::get('/olustur', 'SssController@form')->name('adtrpanel.sss.new');
                Route::post('/kaydet/{id?}', 'SssController@save')->name('adtrpanel.sss.save');
                Route::get('/aktifet/{id}', 'SssController@activated')->name('adtrpanel.sss.activated');
                Route::get('/pasifet/{id}', 'SssController@deactivated')->name('adtrpanel.sss.deactivated');
                Route::get('/duzenle/{id}', 'SssController@form')->name('adtrpanel.sss.edit');
                Route::get('/sil/{id}', 'SssController@delete')->name('adtrpanel.sss.delete');
            });

            // Sabit Sayfa Meta Yönetimi
            Route::group(['prefix' => 'sabit_metalar'], function() {
                Route::match(['get', 'post'], '/', 'StaticMetaController@index')->name('adtrpanel.staticmetas');
                Route::post('/kaydet/{id?}', 'StaticMetaController@save')->name('adtrpanel.staticmetas.save');
                Route::get('/olustur', 'StaticMetaController@form')->name('adtrpanel.staticmetas.new');
                Route::get('/duzenle/{id}', 'StaticMetaController@form')->name('adtrpanel.staticmetas.edit');
            });

            Route::group(['prefix' => 'category'], function () {
                Route::match(['get', 'post'], '/', 'CategoryController@categories')->name('adtrpanel.categories');
                Route::get('/olustur', 'CategoryController@newsForm')->name('adtrpanel.categories.new');
                Route::post('/kaydet/{id?}', 'CategoryController@save')->name('adtrpanel.categories.save');
                Route::get('/duzenle/{id}', 'CategoryController@newsForm')->name('adtrpanel.categories.edit');
                Route::get('/sil/{id}', 'CategoryController@delete')->name('adtrpanel.categories.delete');
            });

            //Yorum İşlemleri
            Route::group(['prefix' => 'yorum_yonetimi'], function () {
                Route::get('/comments', 'CommentController@index')->name('adtrpanel.comments');
                Route::get('/sil/{id}', 'CommentController@delete')->name('adtrpanel.comments.delete');
                Route::get('/cevapla/{id}/{langid}', 'CommentController@commentform')->name('adtrpanel.comments.commentform');
                Route::post('/cevapla/{id}', 'CommentController@update')->name('adtrpanel.comments.update');
                Route::post('/kaydet/{id}', 'CommentController@save')->name('adtrpanel.comments.save');
                Route::get('/onayla/{id}', 'CommentController@activated')->name('adtrpanel.comments.activated');
                Route::get('/onayikaldir/{id}', 'CommentController@deactivated')->name('adtrpanel.comments.deactivated');
            });

            //İletişim Talepleri Rotası
            Route::get('/iletisim-talepleri', 'ContactController@index')->name('adtrpanel.contact');
            Route::get('sil/{id}', 'ContactController@delete')->name('adtrpanel.contact.delete');

            //Personel Yönetimi
            Route::group(['prefix' => 'kadromuz'], function () {
                Route::get('/', 'MedicalStaffController@index')->name('adtrpanel.kadromuz');
                Route::get('/olustur', 'MedicalStaffController@kadromuzForm')->name('adtrpanel.kadromuz.new');
                Route::get('/duzenle/{id}', 'MedicalStaffController@kadromuzForm')->name('adtrpanel.kadromuz.edit');
                Route::post('/kaydet/{id?}', 'MedicalStaffController@save')->name('adtrpanel.kadromuz.save');
                Route::get('/sil/{id}', 'MedicalStaffController@delete')->name('adtrpanel.kadromuz.delete');
            });


            Route::group(['prefix' => 'resimgalerisi_yonetimi'], function () {
                Route::get('/', 'PhotoGalleryController@index')->name('adtrpanel.imagegallery');
                Route::get('/duzenle/{id?}', 'PhotoGalleryController@form')->name('adtrpanel.imagegallery.edit');
                Route::post('/kaydet/{id?}', 'PhotoGalleryController@gallerysave')->name('adtrpanel.imagegallery.save');
                Route::get('/aktifet/{id}', 'PhotoGalleryController@activate')->name('adtrpanel.imagegallery.activated');
                Route::get('/pasifet/{id}', 'PhotoGalleryController@deactivate')->name('adtrpanel.imagegallery.deactivated');
                Route::get('/sil/{id}', 'PhotoGalleryController@delete')->name('adtrpanel.imagegallery.delete');
            });

            Route::group(['prefix' => 'resim_yonetimi'], function () {
                Route::get('/', 'PhotoController@index')->name('adtrpanel.imagegallery.photos');
                Route::get('/duzenle/{id?}', 'PhotoController@form')->name('adtrpanel.imagegallery.photos.edit');
                Route::post('/kaydet/{id?}', 'PhotoController@save')->name('adtrpanel.imagegallery.photos.save');
                Route::get('/aktifet/{id}', 'PhotoController@activate')->name('adtrpanel.imagegallery.photos.activated');
                Route::get('/pasifet/{id}', 'PhotoController@deactivate')->name('adtrpanel.imagegallery.photos.deactivated');
                Route::get('/sil/{id}', 'PhotoController@delete')->name('adtrpanel.imagegallery.photos.delete');
            });

            //Video Galerisi İşlemleri
            Route::group(['prefix' => 'videogalerisi_yonetimi'], function () {
                Route::get('/', 'VideoGalleryController@index')->name('adtrpanel.videogallery');
                Route::get('/galeriler', 'VideoGalleryController@galleries')->name('adtrpanel.videogallery.categories');
                Route::get('/galeri-olustur', 'VideoGalleryController@galleryform')->name('adtrpanel.videogallery.new');
                Route::get('/galeri-duzenle/{id}', 'VideoGalleryController@galleryform')->name('adtrpanel.videogallery.galleryedit');
                Route::post('/galeri-kaydet/{id?}', 'VideoGalleryController@gallerysave')->name('adtrpanel.videogallery.gallerysave');
                Route::get('/silcat/{id}', 'VideoGalleryController@deleteVidCategory')->name('adtrpanel.videogallerycat.delete');

                Route::get('/olustur', 'VideoGalleryController@form')->name('adtrpanel.videogallery.add');
                Route::get('/duzenle/{id}', 'VideoGalleryController@form')->name('adtrpanel.videogallery.edit');
                Route::post('/kaydet/{id?}', 'VideoGalleryController@save')->name('adtrpanel.videogallery.save');
                Route::get('/aktifet/{id}', 'VideoGalleryController@activate')->name('adtrpanel.videogallery.activated');
                Route::get('/pasifet/{id}', 'VideoGalleryController@deactivate')->name('adtrpanel.videogallery.deactivated');
                Route::get('/sil/{id}', 'VideoGalleryController@delete')->name('adtrpanel.videogallery.delete');
            });

            //Dil Yönetimi
            Route::group(['prefix' => 'dil-ayarlari'], function () {
                Route::get('/', 'LanguageController@index')->name('adtrpanel.languages');
                Route::get('/dil_ekle/{id?}', 'LanguageController@languageForm'
                )->name('adtrpanel.language.languageForm');
                Route::get('/setDefault/{id}', 'LanguageController@setDefault')->name('adtrpanel.language.setDefault');
                Route::post('/dil_kaydet/{id?}', 'LanguageController@add')->name('adtrpanel.language.save');
                Route::get('/dil_sil/{id?}', 'LanguageController@delete')->name('adtrpanel.language.delete');
            });

            //Menü İşlemleri
            Route::group(['prefix' => 'menuler'], function () {
                Route::get('/', 'MenuController@index')->name('adtrpanel.menus');
                Route::get('/olustur', 'MenuController@menusform')->name('adtrpanel.menus.new');
                Route::get('/duzenle/{id}', 'MenuController@menusform')->name('adtrpanel.menus.edit');
                Route::post('/kaydet/{id?}', 'MenuController@save')->name('adtrpanel.menus.save');
                Route::get('/sil/{id}', 'MenuController@delete')->name('adtrpanel.menus.delete');
            });

            // Ajax Rotaları
            Route::group(['prefix' => 'ajax'], function () {
                Route::get('notifications', 'AjaxController@notifications')->name('adtrpanel.notifications');
                Route::post('galeriresmiekle', 'AjaxController@galeriresmiekle')->name('adtrpanel.galeriresmiekle');
                Route::post('galeriresmisil', 'AjaxController@galeriresmisil')->name('adtrpanel.galeriresmisil');
                Route::post('articleara', 'AjaxController@articleara')->name('adtrpanel.articleara');
                Route::post('blogara', 'AjaxController@blogara')->name('adtrpanel.blogara');
                Route::post('kategoriara', 'AjaxController@kategoriara')->name('adtrpanel.kategoriara');
                Route::post('pagepasifet', 'AjaxController@pagepasifet')->name('adtrpanel.pagepasifet');
                Route::post('pageaktifet', 'AjaxController@pageaktifet')->name('adtrpanel.pageaktifet');
                Route::post('sonmenuid', 'AjaxController@sonmenuid')->name('adtrpanel.sonmenuid');
                Route::post('menusil', 'AjaxController@menusil')->name('adtrpanel.menusil');
                Route::post('menukaydet', 'AjaxController@menukaydet')->name('adtrpanel.menukaydet');
                Route::post('getAnalyticRealTimeData', 'AjaxController@getAnalyticRealTimeData')->name('adtrpanel.analyticdataguncelle');
                Route::post('makaleara', 'AjaxController@makaleara')->name('adtrpanel.makaleara');
                Route::get('emails', 'AjaxController@emails')->name('adtrpanel.emails');
                Route::get('emailsjson', 'AjaxController@emailsjson')->name('adtrpanel.emails.json');
                Route::get('emaildelete/{id}', 'AjaxController@emaildelete')->name('adtrpanel.emails.delete');
            });
        });
    });

    Route::group(['middleware' => 'web'], function () {
        Route::get('/', 'HomeController@index')->name('anasayfa');
        Route::get('/kontakt', 'IletisimController@index')->name('iletisim');
        Route::post('/suchergebnisse', 'SearchController@index')->name('arama');

        //Blog Rotaları
        Route::group(['prefix' => 'blog'], function (){
            Route::get('/', 'BlogController@index')->name('blogs');
            Route::get('/{slug}', 'BlogController@blog')->name('blog');
            Route::get('/{slug}/amp', 'BlogController@blogAmp')->name('blog.amp');

        });
        Route::group(['prefix' => 'unser-geschaft'], function () {
            Route::get('/', 'OurWorksController@index')->name('works');
            Route::get('/{slug}', 'OurWorksController@work')->name('work');
        });
        //Ajax Rotaları

        Route::group(['prefix' => 'ajax'], function (){
            Route::post('/randevuKayit', 'AjaxController@randevuKayit')->name('ajax.randevuKayit');
            Route::post('/captcha-create', 'CaptchaController@index')->name('ajax.captcha.create');
            Route::post('/yorum-gonder', 'AjaxController@yorumGonder')->name('ajax.yorumGonder');
            Route::post('/iletisim-form-gonder', 'AjaxController@contactFormGonder')->name('ajax.contactFormGonder');
            Route::post('/blog_rated', 'AjaxController@blog_rated')->name('ajax.blog_rated');
            Route::post('/article_rated', 'AjaxController@article_rated')->name('ajax.article_rated');
            Route::post('/set_article_rating', 'AjaxController@set_article_rating')->name('ajax.set_article_rating');
            Route::post('/set_blog_rating', 'AjaxController@set_blog_rating')->name('ajax.set_blog_rating');
            Route::post('/set_sss_rating', 'AjaxController@set_sss_rating')->name('ajax.set_sss_rating');
            Route::post('/set_page_rating', 'AjaxController@set_page_rating')->name('ajax.set_page_rating');
            Route::post('/ask_question', 'AjaxController@askQuestion')->name('ajax.ask_question');
            Route::post('/set_comment_rating', 'AjaxController@set_comment_rating')->name('ajax.set_comment_rating');
            Route::post('/set_video_rating', 'AjaxController@set_video_rating')->name('ajax.set_video_rating');
            Route::post('/set_page_rating', 'AjaxController@set_page_rating')->name('ajax.set_page_rating');
        });

        Route::group(['prefix' => 'fbm'], function () {
            Route::get('/{slug}', 'PageController@index')->name('page');
            Route::get('/{slug}/amp', 'PageController@amp')->name('page.amp');
        });

        Route::get('/videogalerie', 'VideoController@index')->name('videolar');
        Route::get('/videogalerie/{slug?}', 'VideoController@videoDetail')->name('video');

        Route::get('/unser-grunder', 'PageController@kurucumuz')->name('kurucumuz');

        Route::get('/unsere-arzte', 'MedicalStaffController@index')->name('doktorlarimiz');
        Route::get('/unsere-mitarbeiter', 'MedicalStaffController@personel')->name('personelimiz');

        Route::get('/{category_slug}/{article_slug}/amp', 'ArticleController@amp')->name('article.amp');
        Route::get('/{category_slug}/{article_slug}', 'ArticleController@index')->name('article');

        Route::get('/{slug}', 'CategoryController@index')->name('category');
        Route::get('/{slug}/amp', 'CategoryController@amp')->name('category.amp');


    });

});