@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title')
  Video Galerisi
@endsection
@section('content')
<!--İçerik-->
<section class="content inner-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="page-content">
                    <div class="row">
                        <!--Breadcrumb-->
                        <div class="col-lg-12">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="/">Ana Sayfa</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Video Galerisi</li>
                                </ol>
                            </nav>
                        </div>
                        <!--Breadcrumb bitti-->
                        <!--Başlık-->
                        <div class="col-lg-12">
                            <h1 class="page-title">Video Galeri</h1>
                        </div>
                        <!--Başlık Bitti-->
                        <div class="col-lg-3 d-none d-sm-none d-lg-block">
                            <!--Sol Menü-->
                            <div class="page-navigator">
                                <strong>Popüler Videolar</strong>
                                <ul>
                                    @foreach(\App\Models\VideoGalleriesDetail::orderBy('views','Desc')->take(5)->get() as $item)
                                        <li><a  data-fancybox href="{{$item->video_path}}" data-id="{{$item->video_details_id}}" class="views">{{$item->video_name}}</a></li>
                                    @endforeach
                                </ul>
                            </div>
                            <!--Sol Menü Bitti-->
                        </div>
                        <div class="col-lg-9">
                            <!--Sayfa İçeriği-->
                            <article class="page-content-content">
                                <div class="row">

                                    <!--Foto-->
                                    @foreach(\App\Models\VideoGalleriesDetail::all() as $item)
                                    <div class="col-lg-4 col-6">
                                        <div class="media-item">
                                            <a data-fancybox href="{{$item->video_path}}" data-id="{{$item->video_details_id}}" class="views"><img src="{{$item->video_image}}">
                                                <div class="title">{{$item->video_name}}</div></a>
                                        </div>
                                    </div>
                                    @endforeach
                                    <!--Foto Bitti-->

                                </div>
                            </article>
                            <!--Sayfa İçeriği Bitti-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--İçerik Bitti-->

<!--Teknik Servis Formu Modal-->
<div class="modal" id="serviceFormModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Teknik Servis Formu</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="serviceForm" class="service-form no-bg p-0" action="{{route('ajax.technicalForm')}}" method="post">
                    {{ csrf_field() }}
                    <div class="form-group">
                        <select id="productType" name="productType" required class="form-control" title="Ürün Cinsi">
                            @foreach(\App\Models\ProductDetail::select('name')->get() as $item)
                                <option value="{{$item->name}}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-6">
                            <input type="text" id="name" name="name" title="Adınız" required
                                   placeholder="Adınız" class="form-control">
                        </div>
                        <div class="col-lg-6">
                            <input type="text" id="surname" name="surname" required
                                   title="Soyadınız" placeholder="Soyadınız" class="form-control">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-6">
                            <input type="tel" id="tel" name="tel" maxlength="11" pattern='[0-9]{11}' title="11 haneli telefon numaranız"required title="Telefon numaranız"
                                   placeholder="Telefon numaranız" class="form-control">
                        </div>
                        <div class="col-lg-6">
                            <input type="email" id="mail" name="mail" required
                                   title="E-posta adresiniz" placeholder="E-posta adresiniz"
                                   class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <input type="text" id="serial_number" name="serial_number" required
                               title="Ürün seri numarası" placeholder="Ürün seri numarası"
                               class="form-control">
                    </div>
                    <div class="form-group">
                                            <textarea id="comment" name="comment"
                                                      title="Açıklama (varsa)" placeholder="Açıklama (varsa)"
                                                      class="form-control"></textarea>
                    </div>
                    <div class="form-group text-lg-right">
                        <button type="submit" class="btn btn-primary">FORMU GÖNDER</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--Teknik Servis Formu Bitti-->


@endsection

@section('css')
<!--Sayfaya Özel CSS-->
<link rel="stylesheet" href="/themes/{{config('site_settings.themes_dir')}}/css/jquery.fancybox.min.css">
<!--Sayfaya Özel CSS Bitti-->
@endsection

@section('js')

    <script type="application/ld+json">
			{
                "@context": "http://schema.org",
                "@type": "BreadcrumbList",
                "itemListElement": [
                            {
                        "@type": "ListItem",
                        "position": 1,
                        "item": {
                            "@id": "{{route('anasayfa')}}",
                            "name": "Anasayfa"
                        }
                    },                    {
                        "@type": "ListItem",
                        "position": 2,
                        "item": {
                            "@id": "{!! url('/video-galeri') !!}",
                            "name": "Video Galeri"
                        }
                    }

                 ]
            }
</script>

    <script>
        $(document).ready(function(){
            $('.views').click(function(){
                var id = $(this).data('id');
                var _token = '{{csrf_token()}}';
                $.ajax({
                    type: "POST",
                    url: "{{route("ajax.video.views")}}",
                    data: {id:id,_token:_token},
                    headers: {
                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr('content')
                    },
                });
            })
        })
    </script>

    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        $(document).ready(function(){

            @if (session('technicalForm') == 'technicalForm')
            swal({
                title: "Teknik Servis Formu",
                text:  "Firmamız en kısa sürede, size dönüş yapacaktır.",
                icon:  "success"

            });
            @php session()->forget('technicalForm'); @endphp
            @endif
        });
    </script>
<!--Sayfaya Özel Js-->
<script src="/themes/{{config('site_settings.themes_dir')}}/js/jquery.fancybox.min.js"></script>
<!--Sayfaya Özel Js Bitti-->
    @endsection