@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title')
    Arama Sonuçları Sayfası
@endsection
@section('canonical', url()->current())
@section('content')
<!--İçerik-->
<section class="content inner-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="page-content">
                    <div class="row">
                        <!--Breadcrumb-->
                        <div class="col-lg-12">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="/">Ana Sayfa</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Arama Sonucları</li>
                                </ol>
                            </nav>
                        </div>
                        <!--Breadcrumb bitti-->
                        <!--Başlık-->
                        <div class="col-lg-12">
                            <h1 class="page-title">Arama Sonuçları</h1>
                        </div>
                        <!--Başlık Bitti-->
                        <div class="col-lg-12">
                            <!--Sayfa İçeriği-->
                            <article class="page-content-content">

                                <!--Sonuç yoksa-->
                                @if($count == 0 )
                                <div class="no-results text-center">
                                    <p><i class="fas fa-exclamation-circle fa-4x"></i></p>
                                    <strong>Aramanızla ilgili hiçbir sonuç bulunamadı...</strong>
                                </div>
                                @endif
                                <!--Sonuç yoksa bitti-->
                                <!--Sonuç varsa-->
                                @if($count != 0)
                                <div class="results">
                                    <h5>Aramanızla ilgili <strong>{{$count}}</strong> sonuç bulunmuştur:</h5>
                                    <div class="row">

                                        <!--Ürün-->
                                        @foreach($results as $result)
                                        <div class="col-lg-3 col-6">
                                            <a href="/urunler/{{$result->slug}}">
                                                <div class="product">
                                                    <div class="product-image">
                                                        <img src="/{{$result->image}}">
                                                    </div>
                                                    <div class="product-title">
                                                       {{$result->name}}
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                        @endforeach
                                        <!--Ürün Bitti-->


                                        <!--Ürün Bitti-->
                                    </div>
                                </div>
                                @endif
                                <!--Sonuç varsa bitti-->
                            </article>
                            <!--Sayfa İçeriği Bitti-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--İçerik Bitti-->
@include('/themes.'.config('site_settings.themes_dir').'.layouts.partials.technical_form')

    @endsection