
@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title',trans('referance.title'))
@section('description',trans('referance.description'))
@section('canonical', url()->current())
@section('content')
    <!--İçerik-->
    <section class="content inner-page">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="page-content">
                        <div class="row">
                            <!--Breadcrumb-->
                            <div class="col-lg-12">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="{{route('anasayfa')}}">{{ trans('referance.home_page') }}</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">{{trans('referance.page')}}</li>
                                    </ol>
                                </nav>
                            </div>
                            <!--Breadcrumb bitti-->
                            <!--Başlık-->
                            <div class="col-lg-12">
                                <h1 class="page-title">{{ trans('referance.page_title') }}</h1>
                            </div>
                            <!--Başlık Bitti-->
                            <div class="col-lg-12">
                                <!--Sayfa İçeriği-->
                                <article class="page-content-content">
                                    <div class="row">
                                        <!--Referans-->
                                        @foreach(\App\Models\Referance::where('status',1)->orderBy('sort_order')->get() as $referance)
                                        <div class="col-lg-3 col-6">
                                            <div class="media-item">
                                                <img src="{{$referance->image}}">
                                            </div>
                                        </div>
                                        @endforeach
                                        <!--Referans Bitti-->

                                    </div>
                                </article>
                                <!--Sayfa İçeriği Bitti-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--İçerik Bitti-->
    <script type="application/ld+json">
			{
                "@context": "http://schema.org",
                "@type": "BreadcrumbList",
                "itemListElement": [
                   {
                        "@type": "ListItem",
                         "position": 1,
                          "item": {
                               "@id": "{{route('referans')}}",
                                "name": "{{ trans('referance.schema_title') }}"
                          }
                   }
                ]
            }
</script>
    @include('/themes.'.config('site_settings.themes_dir').'.layouts.partials.technical_form')
@endsection

@section('css')
    <link rel="stylesheet" href="themes/{{config('site_settings.themes_dir')}}/css/jquery.fancybox.min.css">
@endsection

@section('js')
    <script src="themes/{{config('site_settings.themes_dir')}}/js/jquery.fancybox.min.js"></script>
@endsection