@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title')
    {{ $productName }}
@endsection
@section('canonical', url()->current())
@section('content')
    <!--İçerik-->
    <section class="content inner-page">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="page-content">
                        <div class="row">
                            <!--Breadcrumb-->
                            <div class="col-lg-12">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="/">Ana Sayfa</a></li>
                                        <li class="breadcrumb-item"><a href="/urunler">Ürünler</a></li>
                                        <li class="breadcrumb-item active" aria-current="/urunler/{{$slug}}">{{$slug}}</li>
                                    </ol>
                                </nav>
                            </div>
                            <!--Breadcrumb bitti-->
                            <!--Başlık-->
                            <div class="col-lg-12">

                                <h1 class="page-title">{{ $productName }}</h1>

                            </div>
                            <!--Başlık Bitti-->
                            <div class="col-lg-12">
                                <!--Sayfa İçeriği-->
                                <article class="page-content-content">
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <!--Sol taraf-->
                                            <div class="product-details-left">
                                                <!--Ürün Görselleri-->
                                                <div class="product-images owl-carousel owl-theme">
                                                    @foreach($productImages as $image)
                                                    <div>
                                                        <a data-fancybox="products" title="Görseli büyütmek için tıklayınız." href="/{{$image->image}}">
                                                            <img src="/{{$image->image}}">
                                                        </a>
                                                    </div>
                                                        @endforeach
                                                </div>
                                                <!--Ürün Görselleri Bitti-->
                                                <!--Sipariş ver-->
                                                <a href="tel:" title="Sipariş vermek için tıklayınız..."
                                                   class="btn btn-arat btn-block mt-2">SİPARİŞ VER</a>
                                                <!--Sipariş ver bitti-->
                                            </div>
                                            <!--Sol taraf bitti-->
                                        </div>
                                        <div class="col-lg-8">
                                            <!--Sağ taraf-->
                                            <div class="product-description" >
                                                <p>Ürün Kodu:  <span style="color:#ff001875;">{{ $product_code }}</span></p>
                                                <div style="right: 15px;top:-5px;position: absolute"><button data-toggle="modal" data-target="#offer" class="btn btn-outline-primary">FİYAT AL</button></div>
                                                {!! $productDescription !!}
                                            </div>
                                            <fieldset class="rating">
                                                    <input type="radio" id="star5" name="rating" value="5"  class="rat5"  /><label  class = "full lblrat5" for="star5" title="5" ></label>
                                                    <input type="radio" id="star4half" name="rating" value="4.5" class="rat45" /><label class="half lblrat45" for="star4half" title="4.5"></label>
                                                    <input type="radio" id="star4" name="rating" value="4" class="rat4" /><label class = "full lblrat4" for="star4" title="4"></label>
                                                    <input type="radio" id="star3half" name="rating" value="3.5"  class="rat35"/><label class="half lblrat35" for="star3half" title="3.5"></label>
                                                    <input type="radio" id="star3" name="rating" value="3"  class="rat3"/><label class = "full lblrat3" for="star3" title="3"></label>
                                                    <input type="radio" id="star2half" name="rating" value="2.5" class="rat25"/><label class="half lblrat25" for="star2half" title="2.5"></label>
                                                    <input type="radio" id="star2" name="rating" value="2" class="rat2"/><label class = "full lblrat2" for="star2" title="2"></label>
                                                    <input type="radio" id="star1half" name="rating" value="1.5" class="rat15"/><label class="half lblrat15" for="star1half" title="1.5"></label>
                                                    <input type="radio" id="star1" name="rating" value="1" class="rat1"/><label class = "full lblrat1" for="star1" title="1"></label>
                                                    <input type="radio" id="starhalf" name="rating" value="0.5" class="rat05"/><label class="half lblrat05" for="starhalf" title="0.5"></label>

                                            </fieldset>
                                            <div style="right: 18px;position: absolute;margin-top: 40px">
                                                <span style="font-size: 11px;"> {{ $count }} Kişi oy verdi. Ortalama Puan {{ $rating }}</span>
                                            </div>
                                            <!--Sağ taraf bitti-->
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="category-products-carousel">
                                                <!--Bağlı ürünler-->
                                                <hr/>
                                                @if(!empty($otherProducts))
                                                    <h2>Kategoriye bağlı diğer ürünler</h2>
                                                @endif
                                                <!--Bağlı ürünler bitti-->
                                                <div class="related-products-carousel owl-carousel owl-theme">
                                                    <!--Ürün-->
                                                    @foreach($otherProducts as $item)
                                                    <div>
                                                        <a href="/urunler/{{$item['slug']}}">
                                                            <div class="product">
                                                                <div class="product-image">
                                                                    <img src="/{{$item['image']}}">
                                                                </div>
                                                                <div class="product-title">
                                                                    {{ $item['name'] }}
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    @endforeach
                                                    <!--Ürün Bitti-->

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </article>
                                <!--Sayfa İçeriği Bitti-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--İçerik Bitti-->

    <!--Teknik Servis Formu Modal-->
    <div class="modal" id="serviceFormModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <span class="modal-title">Teknik Servis Formu</span>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="serviceForm" class="service-form no-bg p-0" action="{{route('ajax.technicalForm')}}" method="post">
                        {{ csrf_field() }}
                        <div class="form-group">
                            <select id="productType" name="productType" required class="form-control" title="Ürün Cinsi">
                                @foreach(\App\Models\ProductDetail::select('name')->get() as $item)
                                    <option value="{{$item->name}}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group row">
                            <div class="col-lg-6">
                                <input type="text" id="name" name="name" title="Adınız" required
                                       placeholder="Adınız" class="form-control">
                            </div>
                            <div class="col-lg-6">
                                <input type="text" id="surname" name="surname" required
                                       title="Soyadınız" placeholder="Soyadınız" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-lg-6">
                                <input type="tel" id="tel" name="tel" maxlength="11" pattern='[0-9]{11}' title="11 haneli telefon numaranız"required title="Telefon numaranız"
                                       placeholder="Telefon numaranız" class="form-control">
                            </div>
                            <div class="col-lg-6">
                                <input type="email" id="mail" name="mail" required
                                       title="E-posta adresiniz" placeholder="E-posta adresiniz"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="text" id="serial_number" name="serial_number" required
                                   title="Ürün seri numarası" placeholder="Ürün seri numarası"
                                   class="form-control">
                        </div>
                        <div class="form-group">
                                            <textarea id="comment" name="comment"
                                                      title="Açıklama (varsa)" placeholder="Açıklama (varsa)"
                                                      class="form-control"></textarea>
                        </div>
                        <div class="form-group text-lg-right">
                            <button type="submit" class="btn btn-primary">FORMU GÖNDER</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--Teknik Servis Formu Bitti-->

    <!--ÜRÜN-DETAY Teklif Al-->
    <div class="modal" id="offer" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <span class="modal-title">Teklif Al Formu</span>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="serviceForm" class="service-form no-bg p-0" action="{{route('ajax.offerForm')}}" method="post">
                        {{ csrf_field() }}
                        <div class="form-group">
                                <input type="text" id="productType" name="productType" title="Ürün Adı" required placeholder="Ürün Adı" class="form-control" value="{{$productName}}" readonly style="background: #3a6ee8;color:white">
                        </div>
                        <div class="form-group row">
                            <div class="col-lg-6">
                                <input type="text" id="name" name="name" title="Adınız" required
                                       placeholder="Adınız" class="form-control">
                            </div>
                            <div class="col-lg-6">
                                <input type="text" id="surname" name="surname" required
                                       title="Soyadınız" placeholder="Soyadınız" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-lg-6">
                                <input type="tel" id="tel" name="tel" maxlength="11" pattern='[0-9]{11}' title="11 haneli telefon numaranız"required title="Telefon numaranız"
                                       placeholder="Telefon numaranız" class="form-control">
                            </div>
                            <div class="col-lg-6">
                                <input type="email" id="mail" name="mail" required
                                       title="E-posta adresiniz" placeholder="E-posta adresiniz"
                                       class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                                            <textarea id="comment" name="comment"
                                                      title="Açıklama (varsa)" placeholder="Açıklama (varsa)"
                                                      class="form-control"></textarea>
                        </div>
                        <div class="form-group text-lg-right">
                            <button type="submit" class="btn btn-primary">FORMU GÖNDER</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--ÜRÜN DETAY Tekli Al Formu Bitti-->


@endsection

<style type="text/css">
    @import url(//netdna.bootstrapcdn.com/font-awesome/3.2.1/css/font-awesome.css);

    fieldset, label { margin: 0; padding: 0; }
    body{ margin: 20px; }
    h1 { font-size: 1.5em; margin: 10px; }

    /****** Style Star Rating Widget *****/

    .rating {
        border: none;
        float: right;
    }

    .rating > input { display: none; }
    .rating > label:before {
        margin: 5px;
        font-size: 1.25em;
        font-family: FontAwesome;
        display: inline-block;
        content: "\f005";
    }

    .rating > .half:before {
        content: "\f089";
        position: absolute;
    }

    .rating > label {
        color: #ddd;
        float: right;
    }

    /***** CSS Magic to Highlight Stars on Hover *****/

    .rating > input:checked ~ label, /* show gold star when clicked */
    .rating:not(:checked) > label:hover, /* hover current star */
    .rating:not(:checked) > label:hover ~ label { color: #FFD700;  } /* hover previous stars in list */

    .rating > input:checked + label:hover, /* hover current star when changing rating */
    .rating > input:checked ~ label:hover,
    .rating > label:hover ~ input:checked ~ label, /* lighten current selection */
    .rating > input:checked ~ label:hover ~ label { color: #FFED85;  }
</style>
<!--Sayfaya Özel CSS-->
<link rel="stylesheet" href="/themes/{{config('site_settings.themes_dir')}}/css/owl-carousel/owl.carousel.min.css">
<link rel="stylesheet" href="/themes/{{config('site_settings.themes_dir')}}/css/owl-carousel/owl.theme.default.min.css">
<link rel="stylesheet" href="/themes/{{config('site_settings.themes_dir')}}/css/jquery.fancybox.min.css">
<!--Sayfaya Özel CSS Bitti-->
@section('cs')


    @endsection

@section('js')

<script>
    var rating = '{{$rating}}';


    if(parseFloat(rating) > 0 ){
       if(parseFloat(rating) == 5){
           $('.rat5').prop("checked",true);
       }else if(parseFloat(rating) >= parseFloat('4.5') && parseFloat(rating) < parseFloat('5')){
           $('.rat45').prop("checked",true);
           $('.lblrat45').prop("title",rating);
       }else if(parseFloat(rating) >= parseFloat('4')   && parseFloat(rating) < parseFloat('4.5')){
           $('.rat4').prop("checked",true);
           $('.lblrat4').prop("title",rating);
       }else if(parseFloat(rating) >= parseFloat('3.5') && parseFloat(rating) < parseFloat('4')){
           $('.rat35').prop("checked",true);
           $('.lblrat35').prop('title',rating);
       }else if(parseFloat(rating) >= parseFloat('3')   && parseFloat(rating) < parseFloat('3.5')){
           $('.rat3').prop("checked",true);
           $('.lblrat3').prop("title",rating);
       }else if(parseFloat(rating) >= parseFloat('2.5') && parseFloat(rating) < parseFloat('3')){
           $('.rat25').prop("checked",true);
           $('.lblrat25').prop("title",rating);
       }else if(parseFloat(rating) >= parseFloat('2')   && parseFloat(rating) < parseFloat('2.5')){
           $('.rat2').prop("checked",true);
           $('.lblrat2').prop("title",rating);
       }else if(parseFloat(rating) >= parseFloat('1.5') && parseFloat(rating) < parseFloat('2')){
           $('.rat15').prop("checked",true);
           $('.lblrat15').prop("title",rating);
       }else if(parseFloat(rating) >= parseFloat('1')   && parseFloat(rating) < parseFloat('1.5')){
           $('.rat1').prop("checked",true);
           $('.lblrat1').prop("title",rating);
       }else{
           $('.rat05').prop("checked",true);
           $('.lblrat05').prop("title",rating);
       }
    }
</script>
    <script>
        $(function () {
            var _token = '{{csrf_token()}}';
            var id = '{{$product_id}}';
            var rating = 0;
            $('input[name="rating"]').click(function(){
                rating = $(this).val();

                $.ajax({
                   type:'post',
                   url :'{{route('ajax.product.rating')}}',
                   data:{id:id,_token:_token,rating:rating},
                   success:function(response){
                        if(response.success){
                            alert(response.success)
                        }else{
                            alert(response.warning);
                        }
                   }
                });
            })
        })


    </script>

    <script>
        $(document).ready(function(){

            @if (session('success-bullient') == 'success')
            swal({
                title: "E-BÜLTEN",
                text:  "E-Bültene kayıt işleminiz başarıyla tamamlandı.En güncel haberleri mail adresinizden takip edebilirsiniz.",
                icon:  "success"

            });
            @php session()->forget('success-bullient'); @endphp
            @elseif(session('warning_bullient')=='warning')
            swal({
                title: "Hata!",
                text:  "Bilgileriniz alınırken bir hata oluştu.",
                icon:  "warning"

            });
            @php session()->forget('warning_bullient') @endphp
            @endif


            @if(session('bullient') == 'warning')
            swal({
                title: "UYARI!",
                text:  "Bu mail adresi E-Bültenimize kayıtlıdır",
                icon:  "warning"

            });
            @php session()->forget('bullient') @endphp
            @endif


        });
    </script>
    <script type="application/ld+json">
			{
        "@context": "http://schema.org",
        "@type": "BreadcrumbList",
        "itemListElement": [
                    {
                "@type": "ListItem",
                "position": 1,
                "item": {
                    "@id": "{{route('anasayfa')}}",
                    "name": "Anasayfa"
                }
            },                    {
                "@type": "ListItem",
                "position": 2,
                "item": {
                    "@id": "{!! url('/urunler') !!}",
                    "name": "Ürünler"
                }
            },                    {
                "@type": "ListItem",
                "position": 3,
                "item": {
                    "@id": "{!! url('/urunler') !!}{{ '/'.$slug }}",
                    "name": "{{$productName}}"
                }
            }                ]
    }
</script>
    <script type="application/ld+json">


    {
      "@context": "http://schema.org",
      "@type": "Product",
      "description": "{{ html_entity_decode($seo_description,ENT_QUOTES ,'UTF-8') }}",
      "brand":"Arat Otomasyon",
      "category":"{{$category_name}}",
      "url":"{!! url('/urunler') !!}{{ '/'.$slug }}",
      "name": "{{$productName}}",
      "image": "{!! asset($product_image) !!}",
      "aggregateRating": {
                    "@type": "AggregateRating",
                    "ratingValue": "{{ $rating }}",
                    "reviewCount": "{{ $count }}"
                }
    }




    </script>


    <!--Sayfaya Özel Js-->
    <script src="/themes/{{config('site_settings.themes_dir')}}/js/owl.carousel.min.js"></script>
    <script src="/themes/{{config('site_settings.themes_dir')}}/js/jquery.fancybox.min.js"></script>
    <script src="/themes/{{config('site_settings.themes_dir')}}/js/product-details.js"></script>
    <!--Sayfaya Özel Js Bitti-->

    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        $(document).ready(function(){

            @if (session('technicalForm') == 'technicalForm')
            swal({
                title: "Teknik Servis Formu",
                text:  "Firmamız en kısa sürede, size dönüş yapacaktır.",
                icon:  "success"

            });
            @php session()->forget('technicalForm'); @endphp
            @endif
        });
    </script>
    <script>
        $(document).ready(function(){
            @if (session('success_offer') == 'success')
            swal({
                title: "Teklif Al Formu",
                text:  "Teklif almak istediğiniz ürün mesajınız başarıyla gönderildi. En kısa sürede sizinle iletişime geçeceğiz",
                icon:  "success"

            });
            @php session()->forget('success_offer') @endphp
            @elseif (session('warning_offer') == 'warning')
            swal({
                title: "Teklif Al Formu",
                text:  "Teklif almak istediğiniz ürün için form gönderilmedi.Tekrar Deneyiniz",
                icon:  "warning"

            });
            @php session()->forget('warning_offer') @endphp
            @endif
        });

    </script>
@endsection