@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title')
Arat Otomasyon Ürünlerimiz
@endsection
@section('canonical', url()->current())
@section('content')
<!--İçerik-->
<section class="content inner-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="page-content">
                    <div class="row">
                        <!--Breadcrumb-->
                        <div class="col-lg-12">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="#">Ana Sayfa</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Ürünler</li>
                                </ol>
                            </nav>
                        </div>
                        <!--Breadcrumb bitti-->
                        <!--Başlık-->
                        <div class="col-lg-12">
                            <h1 class="page-title">Ürünlerimiz</h1>
                        </div>
                        <!--Başlık Bitti-->
                        <div class="col-lg-12">
                            <!--Sayfa İçeriği-->
                            <article class="page-content-content">
                                <div class="row">
                                    <div class="col-lg-3">
                                        <!--Sekme butonları-->
                                        <div class="tab-nav vertical-tabs">
                                            @php $count = -1; @endphp
                                            @foreach(\App\Models\CategoryDetail::all() as $item)
                                                @php $count++; @endphp
                                                @if($count == 0)
                                                    <a class="active" data-tab="kategori-{{$item->category_id}}">{{$item->category_name}}</a>
                                                @else
                                                 <a data-tab="kategori-{{$item->category_id}}">{{ $item->category_name }}</a>
                                                @endif
                                            @endforeach
                                        </div>
                                        <!--Sekme butonları bitti-->
                                    </div>
                                    <div class="col-lg-9">
                                        <!--Sekme içeriği-->
                                        <div class="tab-content">
                                            @foreach($categoryData as $category)
                                                <!--Kategori Sekmesi-->
                                                <div class="tab @if($loop->first) active @endif" data-tab="kategori-{{$category['category_id']}}">
                                                    <div class="row">
                                                        <!--Kategori açıklaması-->
                                                        <div class="col-lg-12">
                                                            <p class="category-desc">{!! $category['category_description']  !!}</p>
                                                        </div>
                                                        <!--Kategori açıklaması bitti-->
                                                        <!--Ürünler-->
                                                        <div class="col-lg-12">
                                                            <div class="row">
                                                                @if(count($category['products']) > 0)
                                                                    @foreach($category['products'] as $card)
                                                                    <!--Ürün-->
                                                                    <div class="col-lg-3 col-6">
                                                                        <a href="/urunler/{{$card['slug']}}">
                                                                            <div class="product">
                                                                                <div class="product-image">
                                                                                    <img src="/{{$card['image']}}">
                                                                                </div>
                                                                                <div class="product-title">
                                                                                    {{ $card['name'] }}
                                                                                </div>
                                                                            </div>
                                                                        </a>
                                                                    </div>
                                                                    <!--Ürün Bitti-->
                                                                    @endforeach
                                                                @endif
                                                            </div>
                                                        </div>
                                                        <!--Ürünler bitti-->
                                                    </div>
                                                </div>
                                                <!--Kategori Sekmesi Bitti-->
                                            @endforeach
                                        </div>
                                        <!--Sekme içeriği bitti-->
                                    </div>
                                </div>
                            </article>
                            <!--Sayfa İçeriği Bitti-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--İçerik Bitti-->
<script type="application/ld+json">
			{
                "@context": "http://schema.org",
                "@type": "BreadcrumbList",
                "itemListElement": [
                            {
                        "@type": "ListItem",
                        "position": 1,
                        "item": {
                            "@id": "{{route('anasayfa')}}",
                            "name": "Anasayfa"
                        }
                    },                    {
                        "@type": "ListItem",
                        "position": 2,
                        "item": {
                            "@id": "{!! url('/urunler') !!}",
                            "name": "Ürünler"
                        }
                    }

                 ]
            }
</script>

@include('/themes.'.config('site_settings.themes_dir').'.layouts.partials.technical_form')
@endsection