@extends('/themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title')
    {{isset($photoGalleryName) ? $photoGalleryName . ' Fotograf Galerisi' : 'Fotograf Galerisi'}}
@endsection
@section('content')
<section class="content inner-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="page-content">
                    <div class="row">
                        <!--Breadcrumb-->
                        <div class="col-lg-12">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Ana Sayfa</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">{{isset($photoGalleryName) ? $photoGalleryName : '' }}</li>
                                </ol>
                            </nav>
                        </div>
                        <!--Breadcrumb bitti-->
                        <!--Başlık-->
                        <div class="col-lg-12">
                            <h1 class="page-title">{{isset($photoGalleryName) ? $photoGalleryName : 'Foto Galeri Baslıgı'}}</h1>
                        </div>
                        <!--Başlık Bitti-->
                        <div class="col-lg-3 d-none d-sm-none d-lg-block">
                            <!--Sol Menü-->
                            <div class="page-navigator">
                                <strong>Diğer Fotograf Galerileri</strong>
                                <ul>
                                    @foreach (\App\Models\PhotoGalleryDetail::where('status',1)->where('photo_gallery_detail_id','!=',$id)->get() as $photo_gallery_detail)
                                    <li><a href="{{route('fotograf-detay',$photo_gallery_detail->slug)}}">{{$photo_gallery_detail->gallery_name}}</a></li>
                                    @endforeach

                                </ul>
                            </div>
                            <!--Sol Menü Bitti-->
                        </div>
                        <div class="col-lg-9">
                            <!--Sayfa İçeriği-->
                            <article class="page-content-content">
                                <div class="row">
                                    @foreach(\App\Models\PhotoDetail::where('photo_gallery_id',$id)->where('status',1)->get() as $photo_gallery)
                                    <!--Foto-->
                                    <div class="col-lg-4 col-6">
                                        <div class="media-item">
                                            <a href="/{{ $photo_gallery->photo_image }}" data-fancybox="gallery"><img src="/{{ $photo_gallery->photo_image }}"></a>
                                        </div>
                                    </div>
                                    <!--Foto Bitti-->
                                     @endforeach
                                </div>
                            </article>
                            <!--Sayfa İçeriği Bitti-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--İçerik Bitti-->

<!--Teknik Servis Formu Modal-->
<div class="modal" id="serviceFormModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Teknik Servis Formu</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="serviceForm" class="service-form no-bg p-0" action="{{route('ajax.technicalForm')}}" method="post">
                    {{ csrf_field() }}
                    <div class="form-group">
                        <select id="productType" name="productType" required class="form-control" title="Ürün Cinsi">
                            @foreach(\App\Models\ProductDetail::select('name')->get() as $item)
                                <option value="{{$item->name}}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-6">
                            <input type="text" id="name" name="name" title="Adınız" required
                                   placeholder="Adınız" class="form-control">
                        </div>
                        <div class="col-lg-6">
                            <input type="text" id="surname" name="surname" required
                                   title="Soyadınız" placeholder="Soyadınız" class="form-control">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-6">
                            <input type="tel" id="tel" name="tel" maxlength="11" pattern='[0-9]{11}' title="11 haneli telefon numaranız"required title="Telefon numaranız"
                                   placeholder="Telefon numaranız" class="form-control">
                        </div>
                        <div class="col-lg-6">
                            <input type="email" id="mail" name="mail" required
                                   title="E-posta adresiniz" placeholder="E-posta adresiniz"
                                   class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <input type="text" id="serial_number" name="serial_number" required
                               title="Ürün seri numarası" placeholder="Ürün seri numarası"
                               class="form-control">
                    </div>
                    <div class="form-group">
                                            <textarea id="comment" name="comment"
                                                      title="Açıklama (varsa)" placeholder="Açıklama (varsa)"
                                                      class="form-control"></textarea>
                    </div>
                    <div class="form-group text-lg-right">
                        <button type="submit" class="btn btn-primary">FORMU GÖNDER</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--Teknik Servis Formu Bitti-->

@endsection
@section('css')
    <link rel="stylesheet" href="/themes/{{config('site_settings.themes_dir')}}/css/jquery.fancybox.min.css">
    @endsection
@section('js')

    <script type="application/ld+json">
			{
        "@context": "http://schema.org",
        "@type": "BreadcrumbList",
        "itemListElement": [
                    {
                "@type": "ListItem",
                "position": 1,
                "item": {
                    "@id": "{{route('anasayfa')}}",
                    "name": "Anasayfa"
                }
            },                    {
                "@type": "ListItem",
                "position": 2,
                "item": {
                    "@id": "{!! url('/fotograf-galeri') !!}",
                    "name": "Fotograf Galeri"
                }
            },                    {
                "@type": "ListItem",
                "position": 3,
                "item": {
                    "@id": "{!! url('/fotograf-detay') !!}{{ '/'.str_slug($photoGalleryName) }}",
                    "name": "{{$photoGalleryName}}"
                }
            }                ]
    }
</script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        $(document).ready(function(){

            @if (session('technicalForm') == 'technicalForm')
            swal({
                title: "Teknik Servis Formu",
                text:  "Firmamız en kısa sürede, size dönüş yapacaktır.",
                icon:  "success"

            });
            @php session()->forget('technicalForm'); @endphp
            @endif
        });
    </script>
    <script src="/themes/{{config('site_settings.themes_dir')}}/js/jquery.fancybox.min.js"></script>
    @endsection