@extends('/themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title')
    Fotograf Galerisi
@endsection
@section('content')
    <!--İçerik-->
    <section class="content inner-page">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="page-content">
                        <div class="row">
                            <!--Breadcrumb-->
                            <div class="col-lg-12">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="/">Ana Sayfa</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Fotograf Galerisi</li>
                                    </ol>
                                </nav>
                            </div>
                            <!--Breadcrumb bitti-->
                            <!--Başlık-->
                            <div class="col-lg-12">
                                <h1 class="page-title">Foto Galeri</h1>
                            </div>
                            <!--Başlık Bitti-->
                            <div class="col-lg-3 d-none d-sm-none d-lg-block">
                                <!--Sol Menü-->
                                <div class="page-navigator">
                                    <strong>Popüler Fotograf Galerileri</strong>
                                    <ul>
                                        @foreach(\App\Models\PhotoGalleryDetail::orderBy('views','Desc')->take(5)->get() as $val)
                                        <li><a href="{{route('fotograf-detay',$val->slug)}} "> {{ $val->gallery_name }}</a></li>
                                            @endforeach
                                    </ul>
                                </div>
                                <!--Sol Menü Bitti-->
                            </div>
                            <div class="col-lg-9">
                                <!--Sayfa İçeriği-->
                                <article class="page-content-content">
                                    <div class="row">

                                        @foreach (\App\Models\PhotoGalleryDetail::where('status',1)->get() as $photo_gallery_detail)
                                        <!--Galeri-->
                                        <div class="col-lg-4 col-6">
                                            <div class="media-item">
                                                <a href="{!! url('/fotograf-detay').'/' . $photo_gallery_detail->slug  !!}">
                                                    <div class="thumb"><img src="{{ $photo_gallery_detail->image }}"> </div>
                                                    <div class="title">{{ $photo_gallery_detail->alt_and_title }}</div>
                                                </a>
                                            </div>
                                        </div>
                                        <!--Galeri Bitti-->
                                         @endforeach

                                    </div>
                                </article>
                                <!--Sayfa İçeriği Bitti-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script type="application/ld+json">
			{
                "@context": "http://schema.org",
                "@type": "BreadcrumbList",
                "itemListElement": [
                            {
                        "@type": "ListItem",
                        "position": 1,
                        "item": {
                            "@id": "{{route('anasayfa')}}",
                            "name": "Anasayfa"
                        }
                    },                    {
                        "@type": "ListItem",
                        "position": 2,
                        "item": {
                            "@id": "{!! url('/fotograf-galeri') !!}",
                            "name": "Fotograf Galerisi"
                        }
                    }

                 ]
            }
</script>
    <!--İçerik Bitti-->
    @include('/themes.'.config('site_settings.themes_dir').'.layouts.partials.technical_form')
    @endsection