

<!--Teknik Servis Formu Modal-->
<div class="modal" id="serviceFormModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Teknik Servis Formu</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="serviceForm" class="service-form no-bg p-0" action="{{route('ajax.technicalForm')}}" method="post">
                    {{ csrf_field() }}
                    <div class="form-group">
                        <select id="productType" name="productType" required class="form-control" title="Ürün Cinsi">
                            @foreach(\App\Models\ProductDetail::select('name')->get() as $item)
                            <option value="{{$item->name}}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-6">
                            <input type="text" id="name" name="name" title="Adınız" required
                                   placeholder="Adınız" class="form-control">
                        </div>
                        <div class="col-lg-6">
                            <input type="text" id="surname" name="surname" required
                                   title="Soyadınız" placeholder="Soyadınız" class="form-control">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-6">
                            <input type="tel" id="tel" name="tel" maxlength="11" pattern='[0-9]{11}' title="11 haneli telefon numaranız"required title="Telefon numaranız"
                                   placeholder="Telefon numaranız" class="form-control">
                        </div>
                        <div class="col-lg-6">
                            <input type="email" id="mail" name="mail" required
                                   title="E-posta adresiniz" placeholder="E-posta adresiniz"
                                   class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <input type="text" id="serial_number" name="serial_number" required
                               title="Ürün seri numarası" placeholder="Ürün seri numarası"
                               class="form-control">
                    </div>
                    <div class="form-group">
                                            <textarea id="comment" name="comment"
                                                      title="Açıklama (varsa)" placeholder="Açıklama (varsa)"
                                                      class="form-control"></textarea>
                    </div>
                    <div class="form-group text-lg-right">
                        <button type="submit" class="btn btn-primary">FORMU GÖNDER</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--Teknik Servis Formu Bitti-->


@section('js')


<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        $(document).ready(function(){

            @if (session('technicalForm') == 'technicalForm')
            swal({
                title: "Teknik Servis Formu",
                text:  "Firmamız en kısa sürede, size dönüş yapacaktır.",
                icon:  "success"

            });
            @php session()->forget('technicalForm'); @endphp
            @endif
        });
    </script>

<script>
    $(document).ready(function(){

        @if (session('success-bullient') == 'success')
        swal({
            title: "E-BÜLTEN",
            text:  "E-Bültene kayıt işleminiz başarıyla tamamlandı.En güncel haberleri mail adresinizden takip edebilirsiniz.",
            icon:  "success"

        });
        @php session()->forget('success-bullient'); @endphp
        @elseif(session('warning_bullient')=='warning')
        swal({
            title: "Hata!",
            text:  "Bilgileriniz alınırken bir hata oluştu.",
            icon:  "warning"

        });
        @php session()->forget('warning_bullient') @endphp
        @endif


        @if(session('bullient') == 'warning')
        swal({
            title: "UYARI!",
            text:  "Bu mail adresi E-Bültenimize kayıtlıdır",
            icon:  "warning"

        });
        @php session()->forget('bullient') @endphp
        @endif


    });
</script>

    @endsection