<!DOCTYPE html>
<html lang="tr">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, user-scalable=no">
    <title>@yield('title') </title>
    <meta name="description" content="@yield('description')">
    <link rel="shortcut icon" type="image/png" href="/uploads/site/favicon.png"/>
    <link rel="shortcut icon" type="image/x-icon" href="/uploads/site/favicon.ico"/>
    <link rel="apple-touch-icon" type="image/x-icon" href="/uploads/site/favicon.ico"/>
    <link rel="alternate" hreflang="tr" href="{{URL::to('/')}}"/>

    <meta property="og:locale" content="{{config('app.locale')}}_{{strtoupper(config('app.locale'))}}"/>
    <meta property="og:type" content="website"/>
    <meta property="og:title" content="@yield('title',config('app.name'))"/>
    <meta property="og:description" content="@yield('description')"/>
    <meta property="og:url" content="{{ url()->current() }}"/>
    <meta property="og:site_name" content="@yield('title')"/>
    <meta property="og:image" content="@yield('image', URL::to('/').'/themes/'.config('site_settings.themes_dir').'/img/common/logo.png')"/>


    <link rel="canonical" href="@yield('canonical')"/>
    <style>
        .splash-screen {
            background: white;
            background-size: cover;
            height: 100%;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            justify-items: center;
            z-index: 155555;
            width: 100%;
            position: fixed;
            top: 0;
        }
    </style>
</head>
<body>
<!--Mobil Header-->
<!--Overlay-->
<section class="overlay"></section>
<!--Splash-->
<div class="splash-screen">
    <div class="splash-logo">
        <img src="/themes/{{config('site_settings.themes_dir')}}/img/common/logo-mobile.png" width="150" title="Arat">
    </div>
</div>
<!--Splash Bitti-->
@include('/themes.'.config('site_settings.themes_dir').'.layouts.partials.header')
<!--Header Bitti-->
@yield('content')

@include('/themes.'.config('site_settings.themes_dir').'.layouts.partials.footer')
<!--Başa dön-->
<a href="#" class="back-to-top"><i class="fas fa-chevron-up"></i> </a>
<!--Başa dön bitti-->
</body>
<!--CSS-->
<link rel="stylesheet" href="/themes/{{config('site_settings.themes_dir')}}/css/bootstrap.min.css">
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.2.0/css/all.css"
      integrity="sha384-hWVjflwFxL6sNzntih27bfxkr27PmbbK/iSvJ+a4+0owXq79v+lsFkW54bOGbiDQ" crossorigin="anonymous">
<link rel="stylesheet" href="/themes/{{config('site_settings.themes_dir')}}/css/style.css">
<link rel="stylesheet" href="/themes/{{config('site_settings.themes_dir')}}/css/responsive.css">
<!--CSS Bitti-->

@yield('css')

<!--Js-->

<script src="/themes/{{config('site_settings.themes_dir')}}/js/jquery-3.3.1.min.js"></script>
<script src="/themes/{{config('site_settings.themes_dir')}}/js/bootstrap.bundle.min.js"></script>
<script src="/themes/{{config('site_settings.themes_dir')}}/js/site.js"></script>
<!--Js Bitti-->

@yield('js')

</html>



