@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title',trans('homepage.title'))
@section('description',trans('homepage.description'))
@section('canonical', url()->current())
@section('content')
<!--İçerik-->
<section class="content home-content">
    <!--Mobil Slider-->
    <div class="d-lg-none d-sm-block">
        <div class="mobile-slider">
            @foreach(\App\Models\SliderDetail::where('slider_status',1)->get() as $mobil_slider)
            <div><a href="#"><img src="{{$mobil_slider->mobil_image}}"></a></div>
            <!--<div><a href="#"><img src="themes/{{config('site_settings.themes_dir')}}/img/slider/slide-2-mobile.jpg"></a></div>-->
            @endforeach
        </div>
    </div>
    <!--Mobil Slider Bitti-->
    <!--Masüstü Slider-->
    <div class="d-none d-sm-none d-lg-block">
        <div class="desktop-slider">
            @foreach(\App\Models\SliderDetail::where('slider_status',1)->get() as $slider)
            <div><a href="{{$slider->url}}"><img src="{{$slider->image}}"></a></div>
            @endforeach
            <!--<div><a href="#"><img src="themes/Arat/img/slider/slide-2-desktop.jpg"></a></div>-->
        </div>
    </div>
    <!--Slider Bitti-->
    <!--Kısaca Biz-->
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="home-about-us">
            {!!  trans('homepage.home_about_us') !!}
                </div>
            </div>
            <div class="col-lg-4 d-none d-sm-none d-lg-block">
                <div class="home-about-links">
                    <ul>
                        <li><a href="{{ route('fotograf') }}"><i class="fas fa-chevron-circle-right"></i>{{ trans('homepage.photo_gallery_title') }}</a></li>
                        <li><a href="{{ route('video') }}"><i class="fas fa-chevron-circle-right"></i> {{ trans('homepage.video_gallery_title') }}</a></li>
                        <li><a href="{{ route('referans') }}"><i class="fas fa-chevron-circle-right"></i> {{ trans('homepage.referance_title') }} </a></li>
                        <li><a href="{{ route('bayi') }}"><i class="fas fa-chevron-circle-right"></i> {{ trans('homepage.dealer_title') }}  </a></li>
                        <li><a href="{{ route('katalog') }}"><i class="fas fa-chevron-circle-right"></i> {{ trans('homepage.e_catalog_title') }}</a></li>
                        <li><a data-toggle="modal" href="#" data-target="#offer"><i class="fas fa-chevron-circle-right"></i>  {{ trans('homepage.price_title') }}</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!--Kısaca Biz Bitti-->
    <!--Ürünlerimiz-->
    <div class="category-carousel-container">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="home-block-title"><h2>{{ trans('homepage.home_product_title') }}</h2></div>
                </div>
            </div>
        </div>
        <!--Carousel-->
        <div class="category-carousel owl-carousel">
            @foreach(\App\Models\Product::join('product_descriptions','product_id','=','id')->where('status',1)->get() as $product)
            <!--Kategori-->
            <div class="carousel-category">
                <a href="{{route('urun_detay',[$product->slug])}}">
                    <div class="img"><img src="/{{ $product->image }}"></div>
                    <div class="title">{{$product->name}}</div>
                    <div class="arrow"><i class="fas fa-chevron-right"></i></div>
                </a>
            </div>
            <!--Kategori Bitti-->
            @endforeach
        </div>
        <!--Carousel Bitti-->
        <!--Carousel Navigasyon-->
        <div class="owl-navigation">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="owl-arrows">
                            <a href="#" class="carousel-prev"><i class="fas fa-chevron-left"></i> </a>
                            <a href="#" class="carousel-next"><i class="fas fa-chevron-right"></i> </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Carousel Navigasyon Bitti-->
    </div>
    <!--Ürünlerimiz Bitti-->
    <!--Amacımız-->
    <div class="our-purpose">
        <div class="container">
            <div class="row">
                <div class="our-purpose-content">
                    <div class="col-lg-12">
                        <div class="home-block-title">
                            <h2>{{trans('homepage.home_block_title')}}</h2>
                        </div>
                        <div class="text-center">
                            <p class="text-muted mb-5">{{trans('homepage.bloc_description')}}</p>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="our-purpose-left">
                                    <h3 style="color: #ffffff;">Otomasyon Sistemlerinde Güvenin Adresi Arat Otomasyon</h3>
                                    <p>Samsun’un önde gelen medya kuruluşlarından olan Haber Gazetesi İlkadım Sanayi
                                        Sitesi’ndeki
                                        yeni yerimizde firmamızı ziyaret etti. Bu ziyaret esnasında Arat Otomasyon hakkında
                                        bilgi
                                        veren işletme sahibi Murat Yurt ‘’Çeyrrek asır önce P.V.C. kart sistemleri ile
                                        başladığımız
                                        firmamızın ürün yelpazesine, otomasyon sistemlerini de ekleyerek Arat Otomasyon
                                        olarak
                                        hizmet veriyoruz. Otomasyon sistemlerinde bölgede lider konumdayız. Tüm
                                        sistemlerimizin
                                        yazılımı bize ait. Türkiye’nin sayılı firmaları arasında yer almaktayız.</p>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="our-porpose-right">
                                    <img src="themes/{{config('site_settings.themes_dir')}}/img/home/our-purpose.png" class="img-fluid mt-3">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Amacımız Bitti-->
    <!--Teknik Servis Formu-->
    <div class="service-form">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="service-form-inner">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="service-form-left">
                                    <div class="home-block-title"><h2>TEKNİK SERVİS FORMU</h2></div>
                                    <p class="service-desc d-none d-sm-none d-lg-block">Arat Otomasyon olarak kart ve otomasyon sistemleri konusunda profesyonel hizmet vermekteyiz.  Otomatik kapılar, geçiş sistemleri ve termal kart yazıcılar gibi ürünlerle ilgili olarak buradaki servis formunu doldurabilirsiniz. Formu doldururken lütfen gerekli tüm bilgileri vermeye özen gösteriniz. Teknik servis talepleriniz ilgili ekibimize ulaşmakta olup, mesai saatleri içerisinde tarafınıza ulaşılarak konuyu en kısa sürede çözmeyi hedeflemekteyiz..</p>
                                    <p class="service-form-footer d-none d-sm-none d-lg-block"><a
                                                href="mailto:aratkart@gmail.com"><i class="fas fa-envelope"></i> {{config('site_settings.iletisim_mail')}}</a>
                                        <a href="tel:{{config('site_settings.iletisim_tel')}}"><i class="fas fa-phone-square"></i> {{config('site_settings.iletisim_tel')}}</a></p>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <!--Form-->
                                <div class="service-form-right">
                                    <form id="serviceForm" action="{{route('ajax.technicalForm')}}" method="post">
                                        {{ csrf_field() }}
                                        <div class="form-group">
                                            <select id="productType" required class="form-control" title="Ürün Cinsi" name="productType">
                                                @foreach(\App\Models\ProductDetail::all() as $item)
                                                    <option value="{{$item->name}}">{{ $item->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-lg-6">
                                                <input type="text" id="name" name="name" title="Adınız" required
                                                       placeholder="Adınız" class="form-control">
                                            </div>
                                            <div class="col-lg-6">
                                                <input type="text" id="surname" name="surname" required
                                                       title="Soyadınız" placeholder="Soyadınız" class="form-control">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-lg-6">
                                                <input type="tel" id="tel" name="tel" required  maxlength="11"  title="11 haneli telefon numaranız"
                                                       placeholder="Telefon numaranız " class="form-control" pattern='[0-9]{11}'>
                                            </div>
                                            <div class="col-lg-6">
                                                <input type="email" id="mail" name="mail" required
                                                       title="E-posta adresiniz" placeholder="E-posta adresiniz"
                                                       class="form-control">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <input type="text" id="serial_number" name="serial_number" required
                                                   title="Ürün seri numarası" placeholder="Ürün seri numarası"
                                                   class="form-control">
                                        </div>
                                        <div class="form-group">
                                            <textarea id="comment" name="comment"
                                                      title="Açıklama (varsa)" placeholder="Açıklama (varsa)"
                                                      class="form-control"></textarea>
                                        </div>
                                        <div class="form-group text-lg-right">
                                            <button type="submit" class="btn btn-primary" >FORMU GÖNDER</button>
                                        </div>
                                    </form>
                                </div>
                                <!--Form Bitti-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Teknik Servis Formu Bitti-->

    <!--Teklif Al-->
    <div class="modal" id="offer" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <span class="modal-title">Teklif Al Formu</span>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="serviceForm" class="service-form no-bg p-0" action="{{route('ajax.offerForm')}}" method="post">
                        {{ csrf_field() }}
                        <div class="form-group">
                            <label style="color:brown">Teklif Alınacak Ürünü Seciniz</label>
                            <select id="productType" name="productType" required class="form-control" title="Teklif alınan ürün">
                                @foreach(\App\Models\ProductDetail::select('name')->get() as $item)
                                    <option value="{{$item->name}}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group row">
                            <div class="col-lg-6">
                                <input type="text" id="name" name="name" title="Adınız" required
                                       placeholder="Adınız" class="form-control">
                            </div>
                            <div class="col-lg-6">
                                <input type="text" id="surname" name="surname" required
                                       title="Soyadınız" placeholder="Soyadınız" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-lg-6">
                                <input type="tel" id="tel" name="tel" maxlength="11" pattern='[0-9]{11}' title="11 haneli telefon numaranız"required title="Telefon numaranız"
                                       placeholder="Telefon numaranız" class="form-control">
                            </div>
                            <div class="col-lg-6">
                                <input type="email" id="mail" name="mail" required
                                       title="E-posta adresiniz" placeholder="E-posta adresiniz"
                                       class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                                            <textarea id="comment" name="comment"
                                                      title="Açıklama (varsa)" placeholder="Açıklama (varsa)"
                                                      class="form-control"></textarea>
                        </div>
                        <div class="form-group text-lg-right">
                            <button type="submit" class="btn btn-primary">FORMU GÖNDER</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--Tekli Al Formu Bitti-->
</section>
<!--İçerik Bitti-->
@endsection

@section('css')
<!--Sayfaya Özel CSS-->
<link rel="stylesheet" href="/themes/{{config('site_settings.themes_dir')}}/css/bx-slider/jquery.bxslider.css">
<link rel="stylesheet" href="/themes/{{config('site_settings.themes_dir')}}/css/owl-carousel/owl.carousel.min.css">
<link rel="stylesheet" href="/themes/{{config('site_settings.themes_dir')}}/css/owl-carousel/owl.theme.default.min.css">
<!--Sayfaya Özel CSS Bitti-->
@endsection


@section('js')


    <script type="application/ld+json">
			{
			"@context": "http://schema.org",
			"@type": "Corporation",
			"name": "{{config('site_settings.site_title')}}",
			"alternatename":"Arat Kart & PVC Kapı Sistemleri",
			"description":"{{config('site_settings.site_description')}}",
			"logo": "{{config('app.url') . config('site_settings.site_logo')}}",
			"address": {
				"@type": "PostalAddress",
				"streetAddress": "{{config('site_settings.iletisim_adres')}}",
				"addressLocality": "{{config('site_settings.site_city')}}",
				"addressRegion": "Tekkeköy",
				"postalCode": "55300"
			},
			"sameAs":[
			"https://www.facebook.com/aratotomasyon/"
			],
            "image":"https://www.aratotomasyon.com/assets/frontend/img/title-bg.jpg",
			"email": "bilgi@aratkartcom",
			"telePhone": "(0362) 445 09 10",
			"areaServed":"TR",
			"url": "https://www.aratotomasyon.com/"
		}
	</script>

<!--Sayfaya Özel Js-->
<script src="/themes/{{config('site_settings.themes_dir')}}/js/jquery.bxslider.min.js"></script>
<script src="/themes/{{config('site_settings.themes_dir')}}/js/owl.carousel.min.js"></script>
<script src="/themes/{{config('site_settings.themes_dir')}}/js/index.js"></script>
<!--Sayfaya Özel Js Bitti-->

<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    $(document).ready(function(){
        @if (session('technicalForm') == 'technicalForm')
        swal({
            title: "Teknik Servis Formu",
            text:  "Firmamız en kısa sürede, size dönüş yapacaktır.",
            icon:  "success"

        });
        @endif
    });
            @php session()->put('technicalForm','null') @endphp


</script>

<script>
    $(document).ready(function(){
        @if (session('success_offer') == 'success')
        swal({
            title: "Teklif Al Formu",
            text:  "Teklif almak istediğiniz ürün başarıyla gönderildi",
            icon:  "success"

        });
        @php session()->forget('success_offer') @endphp
        @elseif (session('warning_offer') == 'warning')
        swal({
            title: "Teklif Al Formu",
            text:  "Teklif almak istediğiniz ürün için form gönderilmedi.Tekrar Deneyiniz",
            icon:  "warning"

        });
        @php session()->forget('warning_offer') @endphp
        @endif
    });

</script>
<script>
    $(document).ready(function(){

        @if (session('success-bullient') == 'success')
        swal({
            title: "E-BÜLTEN",
            text:  "E-Bültene kayıt işleminiz başarıyla tamamlandı.En güncel haberleri mail adresinizden takip edebilirsiniz.",
            icon:  "success"

        });
        @php session()->forget('success-bullient'); @endphp
        @elseif(session('warning_bullient')=='warning')
        swal({
            title: "Hata!",
            text:  "Bilgileriniz alınırken bir hata oluştu.",
            icon:  "warning"

        });
        @php session()->forget('warning_bullient') @endphp
        @endif


        @if(session('bullient') == 'warning')
        swal({
            title: "UYARI!",
            text:  "Bu mail adresi E-Bültenimize kayıtlıdır",
            icon:  "warning"

        });
        @php session()->forget('bullient') @endphp
        @endif


    });
</script>
@endsection