@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title')
    İnsan Kaynakları
@endsection
@section('canonical', url()->current())
@section('content')
    <div class="container">
		<div class="row">
        <div class="col-md-12 main-content">
                <div class="hr-form">
                    <form action="{{route('cv')}}" class="" id="ikform"  method="post" enctype="multipart/form-data">
                        {{csrf_field()}}
                        <div class="row">
                            <div class="col-md-12"> <h6>Fotoğraf Bilgisi</h6> </div>
                            <div class="col-md-4">
                                    <input type="file" name="resim" id="resim" required="required">
                            </div>
                            <div class="col-md-8">
                                <div class="form-input"> Oluşacak CV niz için bir fotoğraf ekleyin. </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <h6>Kişisel Bilgiler</h6> </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="adi" id="adi" type="text" placeholder="Ad Soyad" required="required">
                                </div>
                            </div>
                            <div class="col-md-4"> <div class="form-input">
                                    <input class="form-control" name="eposta" id="eposta" type="email" placeholder="E-posta" required="required">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="telefon" id="telefon" type="text" placeholder="Telefon" required="required">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="dogumyeri" id="dogumyeri" type="text" placeholder="Doğum Yeri" required="required">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="dogumtarihi" id="dogumtarihi" type="text" placeholder="Doğum Tarihi - gg.aa.yyyy" required="required">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="cinsiyet" required="required">
                                        <option value="" selected="selected">Cinsiyet Seçiniz..</option>
                                        <option value="Erkek">Erkek</option>
                                        <option value="KAdın">Kadın</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="medenidurumu" required="required">
                                        <option value="" selected="selected">Medeni Durum Seçiniz..</option>
                                        <option value="Evli">Evli</option>
                                        <option value="Bekar">Bekar</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="ehliyet">
                                        <option value="" selected="selected">Ehliyet Durumu Seçiniz..</option>
                                        <option value="Yok">Ehliyetim Yok</option>
                                        <option value="Var B Sınıfı">Ehliyetim Var - B Sınıfı</option>
                                        <option value="Var C Sınıfı">Ehliyetim Var - C Sınıfı</option>
                                        <option value="Var D Sınıfı">Ehliyetim Var - D Sınıfı</option>
                                        <option value="Var E Sınıfı">Ehliyetim Var - E Sınıfı</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="calismadurumu" onchange="calisilan(this.value);" required="required">
                                        <option value="" selected="selected">Çalışma Durumu Seçiniz..</option>
                                        <option value="Çalışıyorum">Halen Çalışıyorum</option>
                                        <option value="Çalışmıyorum">Çalışmıyorum</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12" id="calisilaninp" style="display: none;">
                                <div class="form-input">
                                    <input class="form-control" name="calisilankurum" id="calisilankurum" type="text" placeholder="Çalışmakta olduğunuz Kurum Yada Firma Adı">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-input">
                                    <textarea class="form-control" name="adres" id="adres" placeholder="Adresiniz" required="required"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row" id="ogrenim">
                            <div class="col-md-12">
                                <h6>Öğrenim Bilgileri</h6>
                                <button id="addogrenim" class="btn btn-primary" type="button"><i class="fa fa-plus-square"></i> Yeni alan ekle </button>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="ogrenimokul[]" id="ogrenimokul[]" type="text" placeholder="Okul Adı" required="required">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="ogrenimbolum[]" id="ogrenimbolum[]" type="text" placeholder="Mezun Olunan Bölüm" required="required">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="ogrenimtarih[]" id="ogrenimtarih[]" type="text" placeholder="Mezuniyet Tarihi" required="required">
                                </div>
                            </div>
                        </div>
                        <div class="row " id="calisma"> <div class="col-md-12">
                                <h6>Çalışma Hayatı</h6>
                                <button type="button" class="btn btn-primary" id="addcalisma"><i class="fa fa-plus-square"></i> Yeni alan ekle </button>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="tecrubeisyeri[]" id="tecrubeisyeri[]" type="text" value="İşyerinin Adı" required="required">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="tecrubegorev[]" id="tecrubegorev[]" type="text" placeholder="Görev" required="required">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="tecrubeayrilma[]" id="tecrubeayrilma[]" type="text" placeholder="Ayrılma Nedeni" required="required">
                                </div>
                            </div>
                        </div>
                        <div class="row " id="referanslar">
                            <div class="col-md-12">
                                <h6>Referanslar</h6>
                                <button class="btn btn-primary" type="button" id="other"> <i class="fa fa-plus-square"></i> Yeni alan ekle </button>
                            </div>
                            <div class="col-md-4 colref">
                                <div class="form-input">
                                    <input class="form-control" name="referansadi[]" id="referansadi[]" type="text" value="Adı Soyadı">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="referansyakinlik[]" id="referansyakinlik[]" type="text" placeholder="Yakınlık Derecesi">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <input class="form-control" name="referanstelefon[]" id="referanstelefon[]" type="text" placeholder="Telefon Numarası">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12"> <h6>Yabancı Dil</h6> </div>
                            <div class="col-md-12">
                                <div class="form-input"> İngilizce </div>
                            </div>
                            <div class="col-md-4"> <div class="form-input">
                                    <select class="form-control" name="ingilizceokuma">
                                        <option value="" selected="selected">Okuma</option>
                                        <option value="cokiyi">Çokiyi</option>
                                        <option value="iyi">İyi</option>
                                        <option value="orta">Orta</option>
                                        <option value="bilmiyorum">Bilmiyorum</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="ingilizceyazma">
                                        <option value="" selected="selected">Yazma</option>
                                        <option value="cokiyi">Çokiyi</option
                                        <option value="iyi">İyi</option>
                                        <option value="orta">Orta</option>
                                        <option value="bilmiyorum">Bilmiyorum</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="ingilizcekonusma">
                                        <option value="" selected="selected">Konuşma</option>
                                        <option value="cokiyi">Çokiyi</option>
                                        <option value="iyi">İyi</option>
                                        <option value="orta">Orta</option>
                                        <option value="bilmiyorum">Bilmiyorum</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-input"> Almanca </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="almancaokuma">
                                        <option value="" selected="selected">Okuma</option>
                                        <option value="cokiyi">Çokiyi</option>
                                        <option value="iyi">İyi</option>
                                        <option value="orta">Orta</option>
                                        <option value="bilmiyorum">Bilmiyorum</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="almancayazma">
                                        <option value="" selected="selected">Yazma</option>
                                        <option value="cokiyi">Çokiyi</option>
                                        <option value="iyi">İyi</option>
                                        <option value="orta">Orta</option>
                                        <option value="bilmiyorum">Bilmiyorum</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="almancakonusma">
                                        <option value="" selected="selected">Konuşma</option>
                                        <option value="cokiyi">Çokiyi</option>
                                        <option value="iyi">İyi</option>
                                        <option value="orta">Orta</option>
                                        <option value="bilmiyorum">Bilmiyorum</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-input"> Arapça </div>
                            </div> <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="arapcaokuma">
                                        <option value="" selected="selected">Okuma</option>
                                        <option value="cokiyi">Çokiyi</option>
                                        <option value="iyi">İyi</option>
                                        <option value="orta">Orta</option>
                                        <option value="bilmiyorum">Bilmiyorum</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="arapcayazma">
                                        <option value="" selected="selected">Yazma</option>
                                        <option value="cokiyi">Çokiyi</option>
                                        <option value="iyi">İyi</option>
                                        <option value="orta">Orta</option>
                                        <option value="bilmiyorum">Bilmiyorum</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-input">
                                    <select class="form-control" name="arapcakonusma">
                                        <option value="" selected="selected">Konuşma</option>
                                        <option value="cokiyi">Çokiyi</option>
                                        <option value="iyi">İyi</option>
                                        <option value="orta">Orta</option>
                                        <option value="bilmiyorum">Bilmiyorum</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <h6>Pozisyon Seçimi</h6>
                            </div>
                            <div class="col-md-12">
                                <div class="form-input">
                                    <select class="form-control" name="pozisyon" onchange="yetkinlikler(this.value);">
                                        <option value="" selected="selected">Başvuru Yapmak İstediğiniz Pozisyon</option>
                                        <option value="1">Muhasebe</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12" style="display: none;" id="yetkinlikler">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <h6>Daha Önce Tamamladığınız Yada Katıldığınız Projeler</h6>
                            </div>
                            <div class="col-md-12">
                                <div class="form-input">
                                    <textarea class="form-control" name="projeler" id="projeler" placeholder="Daha Önce Tamamladığınız Yada Katıldığınız Projeler"></textarea>
                                </div>
                            </div>
                            <div class="col-md-12" style="display: none;" id="yetkinlikler">
                            </div>
                        </div>
                        <div class="row"> <div class="col-md-12">
                                <h6>Kısaca Siz</h6>
                            </div> <div class="col-md-12">
                                <div class="form-input">
                                    <textarea class="form-control" name="ekbilgi" id="ekbilgi" placeholder="Kısaca Siz">

                                    </textarea>
                                </div>
                            </div>
                            <div class="col-md-12" style="display: none;" id="yetkinlikler">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <input type="submit" name="iksubmit" value="CV Gönder" id="iksubmit" class="btn btn-primary">
                            </div>
                        </div>
                    </form>
                </div>
        </div>
    </div>
</div>

<!--Teknik Servis Formu Modal-->
<div class="modal" id="serviceFormModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Teknik Servis Formu</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="serviceForm" class="service-form no-bg p-0" action="{{route('ajax.technicalForm')}}" method="post">
                    {{ csrf_field() }}
                    <div class="form-group">
                        <select id="productType" name="productType" required class="form-control" title="Ürün Cinsi">
                            @foreach(\App\Models\ProductDetail::select('name')->get() as $item)
                                <option value="{{$item->name}}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-6">
                            <input type="text" id="name" name="name" title="Adınız" required
                                   placeholder="Adınız" class="form-control">
                        </div>
                        <div class="col-lg-6">
                            <input type="text" id="surname" name="surname" required
                                   title="Soyadınız" placeholder="Soyadınız" class="form-control">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-6">
                            <input type="tel" id="tel" name="tel" maxlength="11" pattern='[0-9]{11}' title="11 haneli telefon numaranız"required title="Telefon numaranız"
                                   placeholder="Telefon numaranız" class="form-control">
                        </div>
                        <div class="col-lg-6">
                            <input type="email" id="mail" name="mail" required
                                   title="E-posta adresiniz" placeholder="E-posta adresiniz"
                                   class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <input type="text" id="serial_number" name="serial_number" required
                               title="Ürün seri numarası" placeholder="Ürün seri numarası"
                               class="form-control">
                    </div>
                    <div class="form-group">
                                            <textarea id="comment" name="comment"
                                                      title="Açıklama (varsa)" placeholder="Açıklama (varsa)"
                                                      class="form-control"></textarea>
                    </div>
                    <div class="form-group text-lg-right">
                        <button type="submit" class="btn btn-primary">FORMU GÖNDER</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--Teknik Servis Formu Bitti-->

@endsection
@section('js')




    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        $(document).ready(function(){

            @if (session('technicalForm') == 'technicalForm')
            swal({
                title: "Teknik Servis Formu",
                text:  "Firmamız en kısa sürede, size dönüş yapacaktır.",
                icon:  "success"

            });
            @php session()->forget('technicalForm'); @endphp
            @endif
        });
    </script>
    <script>
        $(document).ready(function(){

            @if (session('success-bullient') == 'success')
            swal({
                title: "E-BÜLTEN",
                text:  "E-Bültene kayıt işleminiz başarıyla tamamlandı.En güncel haberleri mail adresinizden takip edebilirsiniz.",
                icon:  "success"

            });
            @php session()->forget('success-bullient'); @endphp
            @elseif(session('warning_bullient')=='warning')
            swal({
                title: "Hata!",
                text:  "Bilgileriniz alınırken bir hata oluştu.",
                icon:  "warning"

            });
            @php session()->forget('warning_bullient') @endphp
            @endif


            @if(session('bullient') == 'warning')
            swal({
                title: "UYARI!",
                text:  "Bu mail adresi E-Bültenimize kayıtlıdır",
                icon:  "warning"

            });
            @php session()->forget('bullient') @endphp
            @endif


        });
    </script>

<script>
    $( document ).ready(function() {

    $( "#addcalisma" ).click(function() {
    var scntDiv2 = $('#calisma');

    $('<div class="col-md-4">' +
        '<div class="form-input">' +
        '<input name="tecrubeisyeri[]" id="tecrubeisyeri[]" type="text" value="İşyerinin Adı" class="form-control">' +
        '</div>' +
        '</div>' +
        '<div class="col-md-4">' +
        '<div class="form-input">' +
        '<input name="tecrubegorev[]" id="tecrubegorev[]" type="text" placeholder="Görev" class="form-control" >' +
        '</div>' +
        '</div>' +
        '<div class="col-md-4">' +
        '<div class="form-input">' +
        '<input name="tecrubeayrilma[]" id="tecrubeayrilma[]" type="text" placeholder="Ayrılma Nedeni" class="form-control"></div></div>').appendTo(scntDiv2);

    });



    $( "#other" ).click(function() {

    var scntDiv2 = $('#referanslar');

    $('<div class="col-md-4"><div class="form-input"><input name="referansadi[]" id="referansadi[]" type="text" value="Adı Soyadı" class="form-control"></div></div><div class="col-md-4"><div class="form-input"><input name="referansyakinlik[]" id="referansyakinlik[]" type="text" placeholder="Yakınlık Derecesi" class="form-control"></div></div><div class="col-md-4"><div class="form-input"><input name="referanstelefon[]" id="referanstelefon[]" type="text" placeholder="Telefon Numarası" class="form-control"></div></div>').appendTo(scntDiv2);


    });



    $( "#addogrenim" ).click(function() {
    var scntDiv3 = $('#ogrenim');

    $('<div class="col-md-4"><div class="form-input"><input name="ogrenimokul[]" id="ogrenimokul[]" type="text" placeholder="Okul Adı" class="form-control"></div></div><div class="col-md-4"><div class="form-input" class="form-control"><input name="ogrenimbolum[]" id="ogrenimbolum[]" type="text" placeholder="Mezun Olunan Bölüm" class="form-control"></div></div><div class="col-md-4"><div class="form-input"><input name="ogrenimtarih[]" id="ogrenimtarih[]" type="text" placeholder="Mezuniyet Tarihi" class="form-control"></div></div>').appendTo(scntDiv3);


    });



    function yetkinlikler(id) {
    $.ajax({
    type: "POST",
    url: "https://www.aratotomasyon.com/yetkinlik-listesi",
    dataType: "json",
    data: {"id":id},
    success: function(sonuc){
    $('#yetkinlikler').fadeIn();
    $('#yetkinlikler').html('<div><h6>Etkin Olarak Bildiğiniz Konuları Seçiniz</h6></div><div class="form-input">'+sonuc.icerik+'</div>');
    },
    error: function(xhr, status, error) {
    alert(xhr.responseText);
    }
    });
    }

    function calisilan(id) {
    if (id === 'Çalışıyorum') {
    $('#calisilaninp').fadeIn();
    } else {
    $('#calisilaninp').fadeOut();
    }
    }

    });


</script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        $(document).ready(function(){
            @if (session('cv')=='success')
            swal({
                title: "CV",
                text:  "Özgeçmis başarılı bir şekilde kaydedildi",
                icon:  "success"

            });
            @php session()->forget('cv') @endphp

            @endif
        });
    </script>
@endsection