@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title',trans('dealer.title'))
@section('description',trans('dealer.description'))
@section('canonical', url()->current())
@section('content')
<!--İçerik-->
<section class="content inner-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="page-content">
                    <div class="row">
                        <!--Breadcrumb-->
                        <div class="col-lg-12">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('anasayfa') }}">{{ trans('dealer.home_page') }}</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">{{ trans('dealer.page') }}</li>
                                </ol>
                            </nav>
                        </div>
                        <!--Breadcrumb bitti-->
                        <!--Başlık-->
                        <div class="col-lg-12">
                            <h1 class="page-title">{{trans('dealer.page_title')}}</h1>
                        </div>
                        <!--Başlık Bitti-->
                        <div class="col-lg-12">
                            <!--Sayfa İçeriği-->
                            <article class="page-content-content">
                                <div class="row">
                                    <!--Bayii-->

                                    @foreach(\App\Models\Dealer::where('status',1)->orderBy('sort_order')->get() as $dealer)
                                    <div class="col-lg-3 col-6">
                                        <div class="media-item">
                                            <img src="{{$dealer->image}}">
                                        </div>
                                    </div>
                                    @endforeach
                                    <!--Bayii Bitti-->
                                </div>
                            </article>
                            <!--Sayfa İçeriği Bitti-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script type="application/ld+json">
			{
                "@context": "http://schema.org",
                "@type": "BreadcrumbList",
                "itemListElement": [
                            {
                        "@type": "ListItem",
                        "position": 1,
                        "item": {
                            "@id": "{{route('anasayfa')}}",
                            "name": "{{trans('general.schema_home_page')}}"
                        }
                    },                    {
                        "@type": "ListItem",
                        "position": 2,
                        "item": {
                            "@id": "{{route('bayi')}}",
                            "name": "Bayiler"
                        }
                    }

                 ]
            }
</script>
<!--İçerik Bitti-->
@include('/themes.'.config('site_settings.themes_dir').'.layouts.partials.technical_form')

    @endsection

@section('cs')
    <!--Sayfaya Özel CSS-->
    <link rel="stylesheet" href="css/jquery.fancybox.min.css">
    <!--Sayfaya Özel CSS Bitti-->
    @endsection

@section('js')

    @endsection