@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title')
Biz Kimiz - Arat Otomasyon Hakkında
@endsection
@section('canonical', url()->current())
@section('content')
<section class="inner-section">
    <div class="container main-container">
        <div class="row">
            <div class="page-content-inner">
                <div class="row">
                    <div class="col-lg-12 col-sm-12 col-xs-12">
                        <img src="/assets/frontend/image/kurumsal.jpg" class="img-responsive img-width100">
                    </div>
                    <div class="col-lg-12 col-sm-12 col-xs-12">
                        <div class="blue-title">
                            <h1 title="inner-blue-title">HAKKIMIZDA</h1>
                        </div>
                        <p>Samsun merkezli olarak faaliyet gösteren firmamız 1986 yılından itibaren siz değerli müşterilerimizin ihtiyaçlarını sorunsuz olarak karşılamaktadır. P.V.C. kart imalatı amacıyla kurulan firmamız daha sonra ürün yelpazesini genişleterek, bugün Plastik Kart sektöründe hak ettiği yeri almıştır. Plastik kart üretimi ile alakalı olarak uzmanlaşan personelimizle 2002/Eylül ayı itibari ile otomasyon sistemlerinde bölgede lider konuma gelmiştir.</p> <p>Uzmanlık alanlarımız kısaca; Personel kimlik kartı, Müşteri kartı, İndirim kartı, Kartlı yada Parmak izli Personel Takip sistemleri, Fotoselli kayar kapılar, Bariyer ve termal baskı sistemleri gibi alanlarda Türkiye'nin sayılı firmaları arasına girmiş durumdayız.</p>
                        <div class="blue-title">
                            <h2 title="inner-blue-title">AMACIMIZ</h2>
                        </div>
                        <p>Avrupa da örneklerini gördüğümüz gibi, plastik kart adına her türlü ürün ve hizmeti tek bir çatı altında, profesyonelce verebilmek için çalışıyoruz. Bu amaca yönelik olarak ilk atılımımız, plastik kart yapımından, kartlı geçiş-kontrol sistemlerine geçmek olmuştur.</p> <p>Firmaların personel kartlarından başlayarak, kartlar için en şık aksesuarları temin etmek, bina girişlerine turnikeli, geçiş-kontrol koymak, otopark için bariyer koymak, toplanan giriş-çıkış bilgileri ile "Personel Puantajlarını" hesaplamak. Binaya gelen ziyaretçileri kayıt altına almak ve izinleri olmayan yerlere girmelerini engellemek, personelin yaka kartı ile bina içindeki kahve, çay makinesi gibi otomatları kullanmasını sağlamak, firmanın yemekhanesindeki tabldot sayılarını turnikeli kontrol ile net ve kesin belirlemek gibi işlemlerin tamanın tek bir sistem ile tamamlamak için çalışıyoruz..</p> <p>Öte yandan alışveriş merkezlerinin manyetik kart sistemlerinide kusursuz hale getirmek için çalışmaktayız.</p>
                        <div class="blue-title">
                            <h2 title="inner-blue-title">BASINDA BİZ</h2>
                        </div>
                        <div class="row">
                            <div class="col-lg-6"><a href="/assets/frontend/image/basindan2.jpg" target="_blank"><img src="/assets/frontend/image/basindan.jpg" width="500" alt="Basında arat Otomasyon" title="Basında arat Otomasyon" class="img-fluid"></a></div> <div class="col-lg-6"><h3>Otomasyon Sistemlerinde Güvenin Adresi Arat Otomasyon</h3><br> Samsun’un önde gelen medya kuruluşlarından olan Haber Gazetesi İlkadım Sanayi Sitesi’ndeki yeni yerimizde firmamızı ziyaret etti. Bu ziyaret esnasında Arat Otomasyon hakkında bilgi veren işletme sahibi Murat Yurt ‘’Çeyrrek asır önce P.V.C. kart sistemleri ile başladığımız firmamızın ürün yelpazesine, otomasyon sistemlerini de ekleyerek Arat Otomasyon olarak hizmet veriyoruz. Otomasyon sistemlerinde bölgede lider konumdayız. Tüm sistemlerimizin yazılımı bize ait. Türkiye’nin sayılı firmaları arasında yer almaktayız. Önce müşteri memnuniyeti ilkesi ile hareket ediyoruz’’ açıklamalarında bulundu. <a href="https://www.aratotomasyon.com/assets/frontend/images/haber_gazetesi.jpg" target="_blank">Habere Git</a></div> </div> </div>


                    </div>
            </div>
        </div>
    </div>
</section>

<!--Teknik Servis Formu Modal-->
<div class="modal" id="serviceFormModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Teknik Servis Formu</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="serviceForm" class="service-form no-bg p-0" action="{{route('ajax.technicalForm')}}" method="post">
                    {{ csrf_field() }}
                    <div class="form-group">
                        <select id="productType" name="productType" required class="form-control" title="Ürün Cinsi">
                            @foreach(\App\Models\ProductDetail::select('name')->get() as $item)
                                <option value="{{$item->name}}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-6">
                            <input type="text" id="name" name="name" title="Adınız" required
                                   placeholder="Adınız" class="form-control">
                        </div>
                        <div class="col-lg-6">
                            <input type="text" id="surname" name="surname" required
                                   title="Soyadınız" placeholder="Soyadınız" class="form-control">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-6">
                            <input type="tel" id="tel" name="tel" maxlength="11" pattern='[0-9]{11}' title="11 haneli telefon numaranız"required title="Telefon numaranız"
                                   placeholder="Telefon numaranız" class="form-control">
                        </div>
                        <div class="col-lg-6">
                            <input type="email" id="mail" name="mail" required
                                   title="E-posta adresiniz" placeholder="E-posta adresiniz"
                                   class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <input type="text" id="serial_number" name="serial_number" required
                               title="Ürün seri numarası" placeholder="Ürün seri numarası"
                               class="form-control">
                    </div>
                    <div class="form-group">
                                            <textarea id="comment" name="comment"
                                                      title="Açıklama (varsa)" placeholder="Açıklama (varsa)"
                                                      class="form-control"></textarea>
                    </div>
                    <div class="form-group text-lg-right">
                        <button type="submit" class="btn btn-primary">FORMU GÖNDER</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--Teknik Servis Formu Bitti-->
    @endsection
@section('js')
    <script type="application/ld+json">
			{
                "@context": "http://schema.org",
                "@type": "BreadcrumbList",
                "itemListElement": [
                            {
                        "@type": "ListItem",
                        "position": 1,
                        "item": {
                            "@id": "{{route('anasayfa')}}",
                            "name": "Anasayfa"
                        }
                    },                    {
                        "@type": "ListItem",
                        "position": 2,
                        "item": {
                            "@id": "{!! url('/kurumsal') !!}",
                            "name": "Kurumsal"
                        }
                    }

                 ]
            }
</script>

    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        $(document).ready(function(){

            @if (session('technicalForm') == 'technicalForm')
            swal({
                title: "Teknik Servis Formu",
                text:  "Firmamız en kısa sürede, size dönüş yapacaktır.",
                icon:  "success"

            });
            @php session()->forget('technicalForm'); @endphp
            @endif
        });
    </script>

    <script>
        $(document).ready(function(){

            @if (session('success-bullient') == 'success')
            swal({
                title: "E-BÜLTEN",
                text:  "E-Bültene kayıt işleminiz başarıyla tamamlandı.En güncel haberleri mail adresinizden takip edebilirsiniz.",
                icon:  "success"

            });
            @php session()->forget('success-bullient'); @endphp
            @elseif(session('warning_bullient')=='warning')
            swal({
                title: "Hata!",
                text:  "Bilgileriniz alınırken bir hata oluştu.",
                icon:  "warning"

            });
            @php session()->forget('warning_bullient') @endphp
            @endif


            @if(session('bullient') == 'warning')
            swal({
                title: "UYARI!",
                text:  "Bu mail adresi E-Bültenimize kayıtlıdır",
                icon:  "warning"

            });
            @php session()->forget('bullient') @endphp
            @endif


        });
    </script>
    @endsection