@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title','Arat Kart İletisim')
@section('description','Arat Kart & Otomasyon sistemleri olarak bizlere ulaşabileceğiniz telefon, mail ve diğer ieltişim bilgilerimiz burada yer almaktadır.')
@section('canonical', url()->current())
@section('content')
<!--İçerik-->
<section class="content inner-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="page-content">
                    <div class="row">
                        <!--Breadcrumb-->
                        <div class="col-lg-12">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="/">Ana Sayfa</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">İletisim</li>
                                </ol>
                            </nav>
                        </div>
                        <!--Breadcrumb bitti-->
                        <!--Başlık-->
                        <div class="col-lg-12">
                            <h1 class="page-title">İletişim</h1>
                        </div>
                        <!--Başlık Bitti-->
                        <div class="col-lg-12">
                            <!--Sayfa İçeriği-->
                            <article class="page-content-content">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="alerts">
                                            <div class="alert alert-success" style="display: none">Form başarıyla gönderildi.</div>
                                            <div class="alert alert-warning" style="display: none">Form gönderilemedi. Lütfen tekrar deneyiniz.</div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <p style="width: 580px">Arat Otomasyon’a aşağıda yer alan telefon ve e-mail adresleri üzerinden ulaşabilirsiniz.</p>
                                    </div>
                                    <div class="col-lg-6">
                                        <h5>İLETİŞİM BİLGİLERİMİZ</h5>
                                        <div class="card">
                                            <div class="card-body">
                                                <p><i class="fas fa-map-marker"></i>  İlkadım Sanayi Sitesi. Uzunlar Cad. No:8 Kirazlık/Tekkeköy</p>
                                                <p><i class="fas fa-phone"></i> +90 (362) 445 0910 - 20</p>
                                                <p><i class="fas fa-phone"></i> +90 (532) 727 9350</p>
                                                <p><i class="fas fa-fax"></i>  +90 (362) 445 0932</p>
                                                <p><i class="fas fa-envelope"></i>  bilgi@aratkartcom</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <h5>BİZE YAZIN</h5>
                                        <form action="{!! url('/sendContact') !!}" method="post">
                                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                            <div class="form-group">
                                                <input type="text" placeholder="Adınız ve Soyadınız" required class="form-control" name="name" id="contactName">
                                            </div>
                                            <div class="form-group">
                                                <input type="email" placeholder="E-posta adresiniz" required class="form-control" name="mail" id="contactMail">
                                            </div>
                                            <div class="form-group">
                                                <textarea id="message" name="contactMessage" class="form-control" required placeholder="Mesajınız" rows="3"></textarea>
                                            </div>
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-arat">Gönder</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </article>
                            <!--Sayfa İçeriği Bitti-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section style="width: 100%">
    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d530.3612103814278!2d36.414974332233214!3d41.23972255437543!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x40887580ae8d0be5%3A0x4be560be565c7c!2s%C4%B0stiklal+Mahallesi%2C+Uzunlar+Cd.+No%3A8%2C+55310+Tekkek%C3%B6y%2FSamsun!5e0!3m2!1str!2str!4v1521449444659" width="100%" height="450" frameborder="0" style="border:0" allowfullscreen=""></iframe>


</section>
<!--İçerik Bitti-->
<script type="application/ld+json">
			{
                "@context": "http://schema.org",
                "@type": "BreadcrumbList",
                "itemListElement": [
                            {
                        "@type": "ListItem",
                        "position": 1,
                        "item": {
                            "@id": "{{route('anasayfa')}}",
                            "name": "Anasayfa"
                        }
                    },                    {
                        "@type": "ListItem",
                        "position": 2,
                        "item": {
                            "@id": "{!! url('/iletisim') !!}",
                            "name": "iletisim"
                        }
                    }

                 ]
            }
</script>

@include('/themes.'.config('site_settings.themes_dir').'.layouts.partials.technical_form')

@endsection
