@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title')
    {{$blog_title}}
@endsection
@section('canonical', url()->current())
@section('content')
<!--İçerik-->
<section class="content inner-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="page-content">
                    <div class="row">
                        <!--Breadcrumb-->
                        <div class="col-lg-12">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="/">Ana Sayfa</a></li>
                                    <li class="breadcrumb-item"><a href="/blog">Blog</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">{{$blog_title}}</li>
                                </ol>
                            </nav>
                        </div>
                        <!--Breadcrumb bitti-->
                        <!--Başlık-->
                        <div class="col-lg-12">
                            <h1 class="page-title">{{$blog_title}}</h1>
                        </div>
                        <!--Başlık Bitti-->
                        <div class="col-lg-9">
                            <!--Sayfa İçeriği-->
                            <article class="page-content-content">
                                <!--Blog Başlığı Bitti-->

                                @foreach(\App\Models\BlogDetail::where('slug',$slug)->get() as $blog_detail)

                                <div class="blog-item">
                                    <div class="blog-image">
                                        <img src="{{ $blog_detail['image'] }}" class="img-fluid">
                                    </div>
                                    <div class="blog-date mt-2">
                                        <small>
                                        @php
                                            $now_date = \Carbon\Carbon::now();
                                            $created_date = $blog_detail['created_at'];
                                            $day  = $created_date->diffInDays($now_date,false);
                                            if($day<1)
                                                $value = 'Bugün yazıldı.';
                                            else
                                                $value = $day . ' gün önce yazıldı.'
                                        @endphp
                                            {{  $value }}

                                        </small>
                                    </div>
                                </div>
                                <!--Blog Başlığı Bitti-->


                                <!--Blog İçeriği-->
                                <div class="blog-content">
                                   {!! $blog_detail['blog_content'] !!}
                                </div>
                                <!--Blog İçeriği Bitti-->
                                @endforeach
                                @include('/themes.'.config('site_settings.themes_dir').'.layouts.partials.rating')

                                <div class="mb-3">
                                    <ul class="social-network social-circle">
                                        <li><a href="{{ config('site_settings.facebook_adres') }}" class="icoFacebook" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                                        <li><a href="{{ config('site_settings.twitter_adres')  }}" class="icoTwitter" title="Twitter"><i class="fab fa-twitter"></i></a></li>
                                        <li><a href="{{ config('site_settings.google_adres')   }}" class="icoGoogle" title="Google +"><i class="fab fa-google-plus-g"></i></a></li>
                                        <li><a href="{{ config('site_settings.linkedin_adres') }}" class="icoLinkedin" title="Linkedin"><i class="fab fa-linkedin"></i></a></li>
                                    </ul>
                                </div>
                                @if (session('success_comment') == 'success_comment')
                                <div class="alerts">
                                    <div class="alert alert-success" >{{session()->get('success_message')}}</div>
                                    @php  session()->put('success_comment','null') @endphp
                                </div>
                                @endif
                                @if (session('warning_comment') == 'warning_comment')
                                    <div class="alerts">
                                        <div class="alert alert-warning" >  {{session()->get('warning_message')}} </div>
                                        @php  session()->put('warning_comment','null') @endphp
                                    </div>
                                @endif
                                <div class="article-comments">
                                    <h5><strong>YORUMLAR</strong></h5>
                                    <!--Yorum yok-->
                                    @if(!empty(\App\Models\Comment::where('status',1)->where('blog_id',$id)->get()))
                                        @foreach(\App\Models\Comment::where('status',1)->where('blog_id',$id)->get() as $blog)

                                        @endforeach
                                    @else
                                    <div class="article-comments-container">
                                        <div class="article-no-comments">
                                            <p><i class="far fa-comments a-no-comment-icon"></i></p>
                                            <p><strong>Bu yazı için herhangi bir yorum yapılmamış.</strong></p>
                                            <p><a href="#writeComment" class="btn btn-arat btn-write-comment"><i class="fa fa-comment"></i> İlk yorumu siz yapın</a></p>
                                        </div>
                                    </div>
                                    @endif
                                    <!--Yorum yok bitti-->
                                    <!-- Siz de yorum yazın -->
                                    <p class="comments-head">SİZ DE YORUM YAZIN</p>
                                    <form id="writeComment" name="writeComment"  action="{!! url('/ajaxComment') !!}" method="post">
                                        <input name="blog_id" type="hidden" value="{{$id}}">
                                        <input name="_token" type="hidden" value="{{csrf_token()}}">
                                        <div class="form-group">
                                            <input type="text" required="required" class="form-control" name="name" id="adi" placeholder="Adınız ve Soyadınız"> </div>
                                        <div class="form-group">
                                            <input type="email" required="required" class="form-control" name="email" id="eposta" placeholder="E-posta adresiniz"> </div>
                                        <div class="form-group">
                                            <textarea name="comment" id="mesaj" required="required" class="form-control" rows="4" minlength="25" placeholder="Yorumunuzu giriniz"></textarea>
                                        </div>
                                        <div class="form-group">
                                            <div class="form-input captchasol" style="text-align: right;"> <span class="captchaimage"></span>&nbsp;&nbsp;<img src="/themes/{{config('site_settings.themes_dir')}}/img/refresh-icon.png" alt="Captca Değiştir" onclick="captchaDegistir();" > </div>
                                            <input class="captchakutu" id="captcha" name="captcha" required="required" type="text" placeholder="Kodu Girin">
                                        </div>
                                        <input type="hidden" id="number1" name="number1" value="">
                                        <input type="hidden" id="number2" name="number2" value="">
                                        <div id="islemsonucu">
                                            <button type="submit" class="btn btn-arat" onclick="">Yorumu Gönder</button>
                                        </div>
                                    </form>
                                    <!-- Siz de yorum yazın -->
                                </div>
                            </article>
                            <!--Sayfa İçeriği Bitti-->
                        </div>


                        <div class="col-lg-3 d-none d-sm-none d-lg-block">
                            <!--Sol Menü-->
                            <div class="page-navigator">
                                <strong>POPÜLER YAZILAR</strong>
                                <ul>

                                    @foreach(\App\Models\BlogDetail::where('blog_id','!=',$id)->orderBy('views','DESC')->take(5)->get() as $blogDetail)
                                        <li><a href=" {{ route('blog_detay',$blogDetail->slug)}}">{{$blogDetail->blog_title}}</a></li>
                                     @endforeach
                                </ul>
                            </div>
                            <!--Sol Menü Bitti-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


</section>


<!--İçerik Bitti-->
<script type="application/ld+json">
			{
        "@context": "http://schema.org",
        "@type": "BreadcrumbList",
        "itemListElement": [
                    {
                "@type": "ListItem",
                "position": 1,
                "item": {
                    "@id": "{{route('anasayfa')}}",
                    "name": "Anasayfa"
                }
            },                    {
                "@type": "ListItem",
                "position": 2,
                "item": {
                    "@id": "{!! url('/blog') !!}",
                    "name": "Blog"
                }
            },                    {
                "@type": "ListItem",
                "position": 3,
                "item": {
                    "@id": "{!! url('/blog-detay') !!}{{ '/'.$slug }}",
                    "name": "{{$blog_title}}"
                }
            }                ]
    }
</script>

<script type="aplication/ld+json">
    {

                            "@context": "http://schema.org",

                            "@type": "BlogPosting",

                            "headline": "{{$blog_title}}",

                            "mainEntityOfPage": {

                                "@type": "WebPage","@id": "{{$blog_url}}"},

                            "author": "AratOtomasyon",

                            "publisher": {

                                "@type": "Organization",

                                "name": "AratOtomasyon",

                                "logo": {

                                    "@type": "ImageObject",

                                    "url": "{{config('app.url') . config('site_settings.site_logo')}}",

                                    "height": 36,

                                    "width": 190

                                }

                            },

                            "alternativeHeadline": "{{$blog_title}}",

                            "image": {

                                "@type": "ImageObject",

                                "url": "{{asset($blog_image)}}",

                                "height": 700,

                                "width": 700

                            },

                            "datePublished": "{{$blog_create_date}}",

                            "dateModified": "{{$blog_update_date}}",

                            "description": "{{$blog_description}}"

                    }
</script>

<script type="application/ld+json">
            {
            "@context": "http://schema.org",
            "@type": "Organization",
            "name": "{{$blog_title}}",
            "description": "{{$blog_description}}",
                "aggregateRating": {
                    "@type": "AggregateRating",
                    "ratingValue": "{{$total_rating}}",
                    "reviewCount": "{{$blog_count}}"
                }
            }
    </script>



@include('/themes.'.config('site_settings.themes_dir').'.layouts.partials.technical_form')
@endsection

