@extends('themes.'.config('site_settings.themes_dir').'.layouts.master')
@section('title','Blog yazılarımız '. $page_title_number)

@section('description', $page_number .' Otomatik kapı, bariyer ve diğer konularda ele aldığımız, kullanıcıları bilgilendirici tarzdaki yazıları burada bulabilirsiniz.')
@section('canonical', url()->current())
@section('content')
    <section class="content inner-page">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="page-content">
                        <div class="row">
                            <!--Breadcrumb-->
                            <div class="col-lg-12">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="{!! url('/') !!}">Ana Sayfa</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Blog</li>
                                    </ol>
                                </nav>
                            </div>
                            <!--Breadcrumb bitti-->

                            <!--Başlık-->
                            <div class="col-lg-12">
                                <h1 class="page-title">Blog</h1>
                            </div>

                            <!--Başlık Bitti-->
                            <div class="col-lg-9">

                                <!--Sayfa İçeriği-->
                                <article class="page-content-content">

                                    <!--Blog-->
                                    @php $blog_detail = \App\Models\BlogDetail::where('status',1)->paginate(5); @endphp
                                    @foreach($blog_detail as $blog)
                                        <div class="blog-item">
                                            <a href="{{ route('blog_detay', $blog->slug) }}" data-id="{{ $blog->blog_id }}" class="common-click">
                                                <div class="blog-image">
                                                    <img src="{{ $blog->image }}" class="img-fluid">
                                                </div>
                                                <div class="blog-title mb-3">
                                                   <h2>{{ $blog->blog_title }}</h2>
                                                </div>
                                                <div class="blog-read-more">
                                                    <a href="{{ route('blog_detay', $blog->slug) }}" class="btn btn-arat common-click" data-id="{{ $blog->blog_id }}">DEVAMINI OKU</a>
                                                </div>
                                            </a>
                                        </div>

                                    @endforeach
                                    {!! str_replace('/?', '?', $blog_detail->render()) !!}
                                    <!--Blog Bitti-->
                                </article>
                                <!--Sayfa İçeriği Bitti-->

                            </div>


                            <div class="col-lg-3 d-none d-sm-none d-lg-block">
                                <!--Sol Menü-->
                                <div class="page-navigator">
                                    <strong>POPÜLER YAZILAR</strong>
                                    <ul>
                                        @foreach(\App\Models\BlogDetail::orderBy('views','DESC')->take(5)->get() as $blogDetail)
                                            <li><a href="{{ route('blog_detay', $blogDetail->slug) }}">{{$blogDetail->blog_title}}</a></li>
                                        @endforeach
                                    </ul>
                                </div>
                                <!--Sol Menü Bitti-->
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script type="application/ld+json">
			{
                "@context": "http://schema.org",
                "@type": "BreadcrumbList",
                "itemListElement": [
                            {
                        "@type": "ListItem",
                        "position": 1,
                        "item": {
                            "@id": "{{route('anasayfa')}}",
                            "name": "Anasayfa"
                        }
                    },                    {
                        "@type": "ListItem",
                        "position": 2,
                        "item": {
                            "@id": "{!! url('/blog') !!}",
                            "name": "Blog"
                        }
                    }
                    ]
            }
    </script>
@include('/themes.'.config('site_settings.themes_dir').'.layouts.partials.technical_form')
@endsection

