@extends('adtrpanel.layouts.master')
    @section('title','Video Galeri Düzenleme Formu')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="@if(isset($gallery)) {{ route('adtrpanel.videogallery.gallerysave', $gallery[0]->gallery_id) }} @else {{ route('adtrpanel.videogallery.gallerysave') }} @endif" enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> Kaydet</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">Genel Bilgiler</a>

                    </li>
                    <li class="nav-item">
                        <a class="nav-link " data-toggle="pill" href="#image">
                            Resim</a>
                    </li>
                </ul>

            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">Genel Bilgiler</option>
                    <option value="#image">Resim</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @section('css')
                                <style>
                                    .active {display: block!important;}
                                </style>
                            @endsection
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}">
                                        <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <!--Genel Bilgiler-->
                    @php $a = 0; @endphp
                    @foreach($languages as $language)
                        @php
                            @$vidGaleryCatDet = \App\Models\VideoGalleryCategoriesDetail::where('language_id',$language->language_id)->where('gallery_id',$gallery[0]->gallery_id)->first();
                        @endphp

                    <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}" style="display: none;" id="{{$language->language_short_name}}">
                        <div class="form-group row">
                            <label for="gallery_name" class="col-sm-2 col-form-label">Galeri Adı <span class="required-input">*</span>
                            </label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control char-textarea" name="gallery_name[{{$language->language_short_name}}]"  maxlength="100"
                                       data-length=100 id="gallery_name" placeholder="Galeri Adı" @if(isset($gallery)) value="{{ @$vidGaleryCatDet->gallery_name }}" @endif />
                                <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="meta_title" class="col-sm-2 col-form-label">Meta Title <span class="required-input">*</span>
                            </label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control char-textarea" name="meta_title[{{$language->language_short_name}}]"  maxlength="100" data-length=100 id="meta_title" placeholder="Galeri Meta Başlığı" @if(isset($gallery)) value="{{ @$vidGaleryCatDet->meta_title }}" @endif />
                                <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="meta_description" class="col-sm-2 col-form-label">Meta Description <span class="required-input">*</span></label>
                            <div class="col-sm-10">
                                <textarea class="form-control" rows="5" id="product_desc" name="meta_description[{{$language->language_short_name}}]" placeholder="Galeri Meta Açıklaması">@if(isset($gallery)) {{@$vidGaleryCatDet->meta_description}} @endif</textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="status" class="col-sm-2 col-form-label">Durum</label>
                            <div class="col-sm-6">
                                <select id="status" class="form-control" name="status[{{$language->language_short_name}}]">
                                    <option value="0" @if(isset($gallery) && @$vidGaleryCatDet->status == 0) selected="selected" @endif>Pasif</option>
                                    <option value="1"@if(isset($gallery) && @$vidGaleryCatDet->status == 1) selected="selected" @endif>Aktif</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="in_gallery" class="col-sm-2 col-form-label">Galeride Göster</label>
                            <div class="col-sm-6">
                                <select id="in_gallery" class="form-control" name="in_gallery[{{$language->language_short_name}}]">
                                    <option value="0" @if(isset($gallery) && @$vidGaleryCatDet->in_gallery == 0) selected="selected" @endif>Hayır</option>
                                    <option value="1"@if(isset($gallery) && @$vidGaleryCatDet->in_gallery == 1) selected="selected" @endif>Evet</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="slug" class="col-sm-2 col-form-label">Galeri SEO URL Yapısı
                                <i class="fas fa-question-circle info-circle" data-html="true" data-toggle="tooltip" data-placement="right" title="Galeriye özel url tanımlamak isterseniz bu alanı doldurunuz.<br />Örn: galeri-adi-ozel-url<br />Boş bırakırsanız galeri adı SEO URL ye  dönüştürülecektir."></i>
                            </label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control char-textarea" name="slug[{{$language->language_short_name}}]" maxlength="150" data-length=150 id="slug" placeholder="Galeri SEO URL Yapısı" @if(isset($gallery)) value="{{ @$vidGaleryCatDet->slug }}" @endif />
                                <span class="char-count">150 </span> <span class="char-count-label">/ 150</span>
                            </div>
                        </div>
                        @if(isset($gallery))
                            <div class="form-group row">
                                <label for="slug" class="col-sm-2 col-form-label">Galeri Kısa Kodu
                                    <i class="fas fa-question-circle info-circle" data-html="true" data-toggle="tooltip" data-placement="right" title="Galeriyi kendi oluşturacağınız sayfalarda kullanabilmeniz için gereken kod parçacığıdır.."></i>
                                </label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" value="[video-galeri-id={{@$vidGaleryCatDet->gallery_id}}]" readonly />
                                </div>
                            </div>
                        @endif
                    </div>
                    @php $a++; @endphp
                    @endforeach
                <!--Genel Bilgi Bittiker-->
                </div>

                <div class="tab-pane" id="image">
                    <!--Resim Bilgileri-->
                    <table class="table table-bordered table-hover">
                        <thead>
                        <tr role="row" class="heading">
                            <th width="40%"> Resim </th>
                            <th width="60%"> Resim Alt ve Title Tagı Bilgisi </th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td class="text-center">
                                <input type="file" name="video_gallery_image" class="form-control"  />
                                <small class="text-muted">800 x 400 piksel olmalıdır.</small>
                                <img src="/{{ @$gallery[0]->image }}" alt="{{ @$gallery[0]->alt_and_title }}" class="img-responsive" />
                            </td>
                            <td>
                                <input type="text" name="alt_and_title" value="{{ @$gallery[0]->alt_and_title }}" class="form-control char-textarea" placeholder="" maxlength="100" data-length="100"  />
                                <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <!--Resim Bilgileri Bitti-->
                </div>

            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#videogallery"]').attr('aria-expanded', 'true');
            $('#videogallery').addClass('show')
        });
    </script>
@endsection