@extends('adtrpanel.layouts.master')
@section('title','Video Galerileri')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ trans('admin.videogallerycategories') }}</h1>
        <div class="text-right">
            <div class="actions btn-set">
                <a href="{{ route('adtrpanel.videogallery.new') }}" class="btn btn-success"><i class="fa fa-check"></i> Yeni Galeri Ekle</a>
            </div>
        </div>
        <!--Ürünler-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 20%;"> {{ trans('admin.gallery_name') }}</th>
                    <th style="width: 10%;"> {{ trans('admin.video_count') }}</th>
                    <th style="width: 10%;"> {{ trans('admin.gallery_short_code') }}</th>
                    <th style="width: 10%;"> {{ trans('admin.status') }}</th>
                    <th style="width: 30%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="gallerylist">
                @if (count($gallery_list) > 0 )
                    @foreach($gallery_list as $gallery)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>{{ $gallery->gallery_name }}</td>
                            <td>{{ $gallery->getVideosCount($gallery->gallery_id) }}</td>
                            <td>[video-galeri-id={{$gallery->gallery_id}}]</td>
                            <td>
                                @if($gallery->status)
                                    <span class="badge badge-success">{{ trans('admin.active') }}</span>
                                @else
                                    <span class="badge badge-danger">{{ trans('admin.passive') }}</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.videogallerycat.delete', $gallery->gallery_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.videogallery.galleryedit', $gallery->gallery_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                                @if($gallery->status)
                                    <a href="{{ route('adtrpanel.videogallery.deactivated', $gallery->gallery_id) }}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> {{ trans('admin.deactivated') }}
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.videogallery.activated', $gallery->gallery_id) }}">
                                        <button class="btn btn-dark btn-sm">
                                            <i class="fas fa-lock-open"></i> {{ trans('admin.activated') }}
                                        </button>
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="5" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="6">
                            {{ $gallery_list->appends(['aranan' => old('aranan')])->links() }}
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="6">{{ trans('admin.no_galeries_found') }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#videogallery"]').attr('aria-expanded', 'true');
            $('#videogallery').addClass('show')
        });
    </script>
@endsection