@extends('adtrpanel.layouts.master')
@section('title','Kullanıcı Yönetimi Düzenle Formu')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="@if(isset($user)) {{ route('adtrpanel.users.save', $user->id) }} @else {{ route('adtrpanel.users.save') }} @endif">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> {{ trans('admin.back') }}
                        </button></a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> {{ trans('admin.save') }}</button>
                    <button type="submit" name="kaydetvedevamet" value="1" class="btn btn-success"><i class="fa fa-check-circle"></i> {{ trans('admin.save_and_continue') }}</button>
                    @if(isset($user) && $user->id != 1)
                        <a href="{{ route('adtrpanel.users.delete', $user->id) }}"> <button class="btn btn-warning"><i class="fa fa-check-circle"></i> Sil</button></a>
                    @endif
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">{{ trans('admin.general_infos') }}</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->
            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <!-- Genel Bilgiler -->
                <div class="tab-pane active" id="general_info">
                    <div class="form-group row">
                        <label for="name" class="col-sm-2 col-form-label">{{ trans('admin.name_and_surname') }} <span class="required-input">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control char-textarea" name="name" required maxlength="100" data-length=100 id="name" placeholder="{{ trans('admin.name_and_surname') }}" @if(isset($user)) value="{{ $user->name }}" @else value="{{ old('name') }}" @endif />
                            <span class="char-count">@if(isset($user)) {{ 100-strlen($user->name) }} @else 100 @endif </span> <span class="char-count-label">/ 100</span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="email" class="col-sm-2 col-form-label">{{ trans('admin.email_address') }} <span class="required-input">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control char-textarea" name="email" required maxlength="100" data-length=100 id="email" placeholder="{{ trans('admin.email_address') }}" @if(isset($user)) value="{{ $user->email }}" @else value="{{ old('email') }}" @endif/>
                            <span class="char-count">@if(isset($user)) {{ 100-strlen($user->email) }} @else 100 @endif </span> <span class="char-count-label">/ 100</span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="status" class="col-sm-2 col-form-label">Durum</label>
                        <div class="col-sm-6">
                            <select id="status" class="form-control" name="status">
                                <option value="0" @if(isset($user) && $user->status == 0) selected="selected" @endif>{{ trans('admin.passive') }}</option>
                                <option value="1" @if(isset($user) && $user->status == 1) selected="selected" @endif>{{ trans('admin.active') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="role_id" class="col-sm-2 col-form-label">Kullanıcı Grubu</label>
                        <div class="col-sm-6">
                            <select id="role_id" class="form-control" name="role_id">
                                @foreach($roles as $role)
                                    <option value="{{ $role->id }}" @if(isset($user) && $user->hasRole($role->name)) selected="selected" @endif>{{ $role->description }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    @if(isset($user))
                        <div class="form-group row">
                            <label for="password" class="col-sm-2 col-form-label">{{ trans('admin.password') }}</label>
                            <div class="col-sm-10">
                                <input type="password" class="form-control" name="password" id="password" placeholder="{{ trans('admin.password') }}" autocomplete="off" />

                                <span class="char-count">{{ trans('admin.if_not_change_blank') }} </span>
                            </div>
                        </div>
                    @else
                        <div class="form-group row">
                            <label for="password" class="col-sm-2 col-form-label">{{ trans('admin.password') }}</label>
                            <div class="col-sm-10">
                                <input type="password" class="form-control" name="password" id="password" placeholder="{{ trans('admin.password') }}">
                                <small class="text-muted">{{ trans('admin.password_length_info') }}</small>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="password_confirmation" class="col-sm-2 col-form-label">{{ trans('admin.comfirm_password') }}</label>
                            <div class="col-sm-10">
                                <input type="password" class="form-control" name="password_confirmation" id="password_confirmation" placeholder="{{ trans('admin.comfirm_password') }}">
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#users"]').attr('aria-expanded', 'true');
            $('#users').addClass('show')
        })
    </script>
@endsection