@extends('adtrpanel.layouts.master')
@section('title','Kullanıcı Yönetimi')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Kullanıcılar</h1>
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 3%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 20%;"> Adı Soyadı</th>
                    <th style="width: 20%;"> Email Adresi</th>
                    <th style="width: 15%;"> Kayıt Tarihi</th>
                    <th style="width: 6%;"> Durumu</th>
                    <th style="width: 10%;"> Kullanıcı Grubu</th>
                    <th style="width: 31%;"> İşlemler</th>
                </tr>
                </thead>
                <tbody id="userlist">
                @if (count($user_list) > 0 )
                    @foreach($user_list as $user)
                        <tr>
                            <td class="text-center">
                                @if($user->id != 1)
                                    <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                        <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                        <span></span>
                                    </label>
                                @endif
                            </td>
                            <td>{{ $user->name }}</td>
                            <td>{{ $user->email }}</td>
                            <td>{{ $user->created_at }}</td>
                            <td>
                                @if($user->status)
                                    <span class="badge badge-success">Aktif</span>
                                @else
                                    <span class="badge badge-danger">Pasif</span>
                                @endif
                            </td>
                            <td>{{$user->roleUser->role->description}} </td>
                            <td>
                                @if($user->id != 1)
                                    <a href="{{ route('adtrpanel.users.delete', $user->id) }}">
                                        <button class="btn btn-danger btn-sm">
                                            <i class="fa fa-times"></i> Sil
                                        </button>
                                    </a>
                                @endif
                                <a href="{{ route('adtrpanel.users.edit', $user->id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="6" style="text-align: right;">Seçilileri &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">Seçiniz</option>
                                <option value="sil">Sil</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="7"
                            style="text-align: right;">{{ $user_list->appends(['aranan' => old('aranan')])->links() }}</td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="7">Hiçbir kullanıcı bulunamadı</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#users"]').attr('aria-expanded', 'true');
            $('#users').addClass('show')
        });
    </script>
@endsection