@extends('adtrpanel.layouts.master')
@section('title','Kullanıcı Grupları')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Kullanıcı Grupları</h1>
        <div class="text-right">
            <div class="actions btn-set">
                <a href="{{ route('adtrpanel.usergroups.new') }}"><button type="button" name="ekle" value="1" class="btn btn-success"><i class="fa fa-plus"></i> Yeni Kullanıcı Grubu Ekle</button></a>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 20%;"> Kullanıcı Grubu Adı</th>
                    <th style="width: 25%;"> Kullanıcı Grubu Açıklaması</th>
                    <th style="width: 20%;"> Gruptaki Kullanıcı Sayısı</th>
                    <th style="width: 30%;"> İşlemler</th>
                </tr>
                </thead>
                <tbody id="grouplist">
                @if (count($userGroups) > 0 )
                    @foreach($userGroups as $userGroup)
                        <tr>
                            <td class="text-center">
                                @if($userGroup->id != 1)
                                    <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                        <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                        <span></span>
                                    </label>
                                @endif
                            </td>
                            <td>{{ $userGroup->name }}</td>
                            <td>{{ $userGroup->description }}</td>
                            <td></td>
                            <td>
                                @if($userGroup->id != 1)
                                    <a href="{{ route('adtrpanel.usergroups.delete', $userGroup->id) }}">
                                        <button class="btn btn-danger btn-sm">
                                            <i class="fa fa-times"></i> Sil
                                        </button>
                                    </a>
                                @endif
                                <a href="{{ route('adtrpanel.usergroups.edit', $userGroup->id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.usergroups.authedit', $userGroup->id) }}">
                                    <button class="btn btn-warning btn-sm">
                                        <i class="fa fa-edit"></i> Grup Yetkilerini Düzenle
                                    </button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="4" style="text-align: right;">Seçilileri &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">Seçiniz</option>
                                <option value="sil">Sil</option>
                            </select>
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="5">Hiçbir kullanıcı grubu bulunamadı</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#users"]').attr('aria-expanded', 'true');
            $('#users').addClass('show')
        });
    </script>
@endsection