@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="@if(isset($userGroup)) {{ route('adtrpanel.usergroups.save', $userGroup->id) }} @else {{ route('adtrpanel.usergroups.save') }} @endif">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> {{ trans('admin.back') }}
                        </button></a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> {{ trans('admin.save') }}</button>
                    <button type="submit" name="kaydetvedevamet" value="1" class="btn btn-success"><i class="fa fa-check-circle"></i> {{ trans('admin.save_and_continue') }}</button>
                    @if(isset($userGroup) && $userGroup->id != 1)
                        <a href="{{ route('adtrpanel.usergroups.delete', $userGroup->id) }}"> <button class="btn btn-warning"><i class="fa fa-check-circle"></i> Sil</button></a>
                    @endif
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">{{ trans('admin.general_infos') }}</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->
            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <!-- Genel Bilgiler -->
                <div class="tab-pane active" id="general_info">
                    <div class="form-group row">
                        <label for="name" class="col-sm-2 col-form-label">Grup Adı <span class="required-input">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control char-textarea" name="name" required maxlength="100" data-length=100 id="name" placeholder="Grup Adı" @if(isset($userGroup)) value="{{ $userGroup->name }}" @else value="{{ old('name') }}" @endif />
                            <span class="char-count">@if(isset($userGroup)) {{ 100-strlen($userGroup->name) }} @else 100 @endif </span> <span class="char-count-label">/ 100</span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="description" class="col-sm-2 col-form-label">Grup Açıklaması <span class="required-input">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control char-textarea" name="description" required maxlength="100" data-length=100 id="description" placeholder="Grup Açıklaması" @if(isset($userGroup)) value="{{ $userGroup->description }}" @else value="{{ old('description') }}" @endif/>
                            <span class="char-count">@if(isset($userGroup)) {{ 100-strlen($userGroup->description) }} @else 100 @endif </span> <span class="char-count-label">/ 100</span>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#users"]').attr('aria-expanded', 'true');
            $('#users').addClass('show')
        })
    </script>
@endsection