@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="{{ route('adtrpanel.usergroups.authsave', $role_id) }}">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}">
                        <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> {{ trans('admin.back') }}
                        </button>
                    </a>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> {{ trans('admin.save') }}</button>
                    <button type="submit" name="kaydetvedevamet" value="1" class="btn btn-success"><i class="fa fa-check-circle"></i> {{ trans('admin.save_and_continue') }}</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">{{ trans('admin.general_infos') }}</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->
            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <!-- Genel Bilgiler -->
                <div class="tab-pane active" id="general_info">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th style="width: 40%;"> Yetki Listesi</th>
                                    <th style="width: 15%;" class="text-center"> Görme</th>
                                    <th style="width: 15%;" class="text-center"> Ekleme</th>
                                    <th style="width: 15%;" class="text-center"> Düzenleme</th>
                                    <th style="width: 15%;" class="text-center"> Silme</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($auth_list as $auth)
                                    <tr>
                                        <td><input type="hidden" name="permissions[{{$auth->permission_id}}]" value="{{$auth->permission_id}}" />{{ $auth->model->model_desc }}</td>
                                        <td class="text-center"><input type="checkbox" name="read[{{$auth->permission_id}}]" value="1" @if($auth->read) checked="checked" @endif/></td>
                                        <td class="text-center"><input type="checkbox" name="create[{{$auth->permission_id}}]" value="1" @if($auth->create) checked="checked" @endif/></td>
                                        <td class="text-center"><input type="checkbox" name="update[{{$auth->permission_id}}]" value="1" @if($auth->update) checked="checked" @endif/></td>
                                        <td class="text-center"><input type="checkbox" name="delete[{{$auth->permission_id}}]" value="1" @if($auth->delete) checked="checked" @endif/></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
    <link rel="stylesheet" href="/admin/css/icheck-bootstrap.min.css">
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#users"]').attr('aria-expanded', 'true');
            $('#users').addClass('show')
        })
    </script>
@endsection