@extends('adtrpanel.layouts.master')
@section('title','Teklifler')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ trans('Teklifler') }}</h1>
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 10%;"> {{ trans('Adı - Soyadı') }}</th>
                    <th style="width: 15%;"> {{ trans('Ürün Adı') }}</th>
                    <th style="width: 10%;"> {{ trans('Telefon Numarası') }}</th>
                    <th style="width: 20%;"> {{ trans('E-mail Adresi') }}</th>
                    <th style="width: 15%;"> {{ trans('Tarih - Saat') }}</th>
                    <th style="width: 5%;"> Durum</th>
                    <th style="width: 30%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="commentlist">
                @if (count($offers) > 0 )
                    @foreach($offers as $offer)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>{{ $offer->name }}  {{$offer->surname}}</td>
                            <td>{{ $offer->product_name }} </td>
                            <td>{{ $offer->phone }}</td>
                            <td>{{ $offer->email }}</td>
                            <td>{{ $offer->created_at }}</td>
                            <td>
                                @if($offer->status)

                                    <span class="badge badge-success">Okundu</span>
                                @else

                                    <span class="badge badge-danger">Okunmadı</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{route('adtrpanel.offer.delete',['id'=>$offer->id ])}}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a  href="" data-toggle="modal" data-target="#offer_read{{ $offer->id }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-book"></i> Teklifi Oku
                                    </button>
                                </a>
                                <!-- modal-->
                                <div class="modal" id="offer_read{{ $offer->id  }}" tabindex="-1" role="dialog" aria-labelledby="modal_goruntule_label"
                                     aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="modal_goruntule_label">Mesajı</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {{ $offer->comment }}
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-outline-primary" data-dismiss="modal" onclick="offerRead({{$offer->id}})">Okudum</button>
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal" >Kapat</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- modal bitti-->
                                @if($offer->status == 0)
                                    <a href="{{route('adtrpanel.offer.active',['id' => $offer->id])}}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> Okunmadı
                                        </button>
                                    </a>
                                @else
                                    <a href="">
                                        <button class="btn btn-dark btn-sm" disabled="disabled">
                                            <i class="fas fa-lock-open"></i> Okundu
                                        </button>
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="7" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="9">

                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">{{ trans('Teklif Al Mevcut degil') }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>


    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')

    <script>

    function  offerRead(id) {

        $.ajax({
            type: "POST",
            url: "{{route('adtrpanel.ajax.sendOffer')}}",
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr('content')
            },
            data: {id:id},
            dataType: "json",
            success:function(response){
                if(response['success'] == 'success'){
                  location.reload();
                }
            }

        });
    }
    </script>

    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#comments"]').attr('aria-expanded', 'true');
            $('#comments').addClass('show')
        });
    </script>
@endsection