@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" autocomplete="off" action="@if(isset($static_meta)) {{ route('adtrpanel.staticmetas.save', $static_meta->meta_id) }} @else {{ route('adtrpanel.staticmetas.save') }} @endif" enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> {{ trans('admin.save') }}</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">Sayfa Bilgileri</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#meta_info">{{ trans('admin.meta_infos') }}</a>
                    </li>

                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->
            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">Sayfa Bilgileri</option>
                    <option data-toggle="pill" value="#meta_info">{{ trans('admin.meta_infos') }}</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                        <div class="form-group row">
                            <label for="page_title" class="col-sm-2 col-form-label">Sayfa Başlığı <span class=" -input">*</span>
                            </label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control char-textarea" name="page_title"   maxlength="100"
                                       data-length=100 id="page_title" placeholder="Sayfa Başlığı" value="{{ @$static_meta->page_name }}"/>
                                <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="page_slug" class="col-sm-2 col-form-label">Sayfa Slug <span class=" -input">*</span>
                            </label>
                            <div class="col-sm-10">
                                <input @if(isset($static_meta)) readonly @endif type="text" class="form-control char-textarea" name="page_slug"   maxlength="100"
                                       data-length=100 id="page_slug" placeholder="Sayfa Slug"value="{{ @$static_meta->page_slug }}"/>
                                <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                            </div>
                        </div>
                <!-- Genel Bilgi Bitti -->
                </div>
                <div class="tab-pane" id="meta_info">
                    <!--Meta Bilgileri-->
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}_meta">
                                        <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @php $a = 0; @endphp
                    @foreach($languages as $language)
                        <div class="tab-pane {{$language->language_default == 1 ? "active" : ""}}" style="display: none;" id="{{$language->language_short_name}}_meta">
                            <!--Meta Bilgileri-->
                            <div class="form-group row">
                                <label for="page_meta_title" class="col-sm-2 col-form-label">{{ trans('admin.meta_title') }}
                                </label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control char-textarea" name="page_meta_title[{{$language->language_short_name}}]"   maxlength="100"
                                           data-length=100 id="page_meta_title" placeholder="Sayfa Meta Başlığı" value="@if(isset($static_meta)){{$static_meta->metaDetail($static_meta->meta_id, $language->language_id)->meta_title}}@endif" />
                                    <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="page_meta_description" class="col-sm-2 col-form-label">{{ trans('admin.page_meta_description') }} </label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" rows="5" id="page_meta_description" name="page_meta_description[{{$language->language_short_name}}]" placeholder="Sayfa Meta Açıklaması">@if(isset($static_meta)){{$static_meta->metaDetail($static_meta->meta_id, $language->language_id)->meta_description}}@endif</textarea>
                                </div>
                            </div>
                            <!--Meta Bilgileri Bitti-->
                        </div>
                    @php $a++; @endphp
                @endforeach
                <!--Meta Bilgileri Bitti-->
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
    <style>
        .active {display:block!important;}
    </style>
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#pages"]').attr('aria-expanded', 'true');
            $('#pages').addClass('show')
        });
    </script>
    <script src="/ckeditor/ckeditor.js"></script>
    <script>
        var editorConfig = {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        };
        @foreach($languages as $language)
        CKEDITOR.replace( 'page_content[{{$language->language_short_name}}]',  editorConfig);
        @endforeach

    </script>
@endsection