@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Sabit Sayfalar</h1>
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 45%;"> Sayfa</th>
                    <th style="width: 35%;"> İşlemler</th>
                </tr>
                </thead>
                <tbody id="pagelist">
                @if (count($static_metas) > 0 )
                    @foreach($static_metas as $static_meta)
                        <tr>
                            <td>{{ $static_meta->page_name }}</td>
                            <td>
                                <a href="{{ route('adtrpanel.staticmetas.edit', $static_meta->meta_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="9">
                            {{ $static_metas->appends(['aranan' => old('aranan')])->links() }}
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">Hiçbir sayfa bulunamadı</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#pages"]').attr('aria-expanded', 'true');
            $('#pages').addClass('show')
        });
    </script>
@endsection