@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post"
              action="@if(isset($sss)) {{ route('adtrpanel.sss.save', $sss->sss_id) }} @else {{ route('adtrpanel.sss.save') }} @endif">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}">
                        <button type="button" name="back" class="btn btn-secondary-outline"><i
                                    class="fa fa-angle-left"></i> Geri
                        </button>
                    </a>
                    <button type="reset" class="btn btn-secondary-outline"><i
                                class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i
                                class="fa fa-check"></i> {{ trans('admin.save') }}</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill"
                           href="#general_info">{{ trans('admin.general_infos') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#other">Diğer</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>
                    <option data-toggle="pill" value="#other">Diğer</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    @section('css')
                        <style>
                            .active {
                                display: block !important;
                            }
                        </style>
                    @endsection
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}"
                                       data-toggle="pill" href="#{{$language->language_short_name}}">
                                        <img class="img-thumbnail rounded mx-auto d-block"
                                             src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px"
                                           class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @foreach($languages as $language)
                        <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}" style="display: none;" id="{{$language->language_short_name}}">
                            <div class="form-group row">
                                <label for="question" class="col-sm-2 col-form-label">Soru<span class="required-input">*</span></label>
                                <div class="col-sm-10">
                                    <textarea rows="3" class="form-control" name="question[{{$language->language_short_name}}]"  id="question" placeholder="Soru">@if(isset($sss)){{@$sss->getSssDetail($sss->sss_id, $language->language_id)->question}}@endif</textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="answer" class="col-sm-2 col-form-label">Cevap<span class="required-input">*</span></label>
                                <div class="col-sm-10">
                                    <textarea rows="5" class="form-control" name="answer[{{$language->language_short_name}}]"  id="answer" placeholder="Cevap">@if(isset($sss)){{@$sss->getSssDetail($sss->sss_id, $language->language_id)->answer}}@endif</textarea>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="tab-pane" id="other">
                    <div class="form-group row">
                        <label for="article_id" class="col-sm-2 col-form-label">Bağlı Olduğu Makale <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <select class="js-example-basic-single form-control" name="article_id">
                                @foreach($articles->where('language_id', 1) as $article)
                                    <option @if(isset($sss) && $sss->article_id == $article->article_id) selected @endif value="{{$article->article_id}}">{{$article->article_title}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="status" class="col-sm-2 col-form-label">{{ trans('admin.status') }}</label>
                        <div class="col-sm-6">
                            <select id="status" class="form-control" name="status">
                                <option value="0"
                                        @if(isset($sss) && $sss->status == 0) selected="selected" @endif>{{ trans('admin.passive') }}</option>
                                <option selected value="1"
                                        @if(isset($sss) && $sss->status == 1) selected="selected" @endif>{{ trans('admin.active') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="rank" class="col-sm-2 col-form-label">{{ trans('admin.rank') }}</label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" name="rank" id="rank"
                                   placeholder="Sayfa sıra Numarası" @if(isset($sss)) value="{{ $sss->rank }}" @endif />
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
@endsection
@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
        });
    </script>
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#project"]').attr('aria-expanded', 'true');
            $('#project').addClass('show')

        });

    </script>
    <script src="/ckeditor/ckeditor.js"></script>
    <script>
        var editorConfig = {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        };
        @foreach($languages as $language)
            CKEDITOR.replace( 'answer[{{$language->language_short_name}}]',  editorConfig);
        @endforeach
    </script>
    <script>
        function makaleAra() {
            var kelime = $("input[name='article']").val();
            $.ajax({
                type: "post",
                url: "{{route('adtrpanel.makaleara')}}",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {"kelime": kelime},
                dataType: "json",
                success: function (cevap) {
                    if (cevap.sonuc === 'basarili') {
                        $(".makaleler").html(cevap.deger);
                    }
                }
            });
        }

        function makaletamamla(name) {//tamamla fonsiyonu çağırılınca gönderilen veriyi al
            $("#article_id").val(name);//inputa koy
            $(".makaleler").text("");//kelimeler clasına ait divi temizle
        }
    </script>
@endsection