@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Sık Sorulan Sorular</h1>
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 30%;"> Makale Adı</th>
                    <th style="width: 20%;"> Soru</th>
                    <th style="width: 20%;"> Cevap</th>
                    <th style="width: 5%;"> Durumu</th>
                    <th style="width: 25%;"> İşlemler</th>
                </tr>
                </thead>
                <tbody id="ssslist">
                @if (count($ssses) > 0 )
                    @foreach($ssses as $sss)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>
                                <a href="{{route('adtrpanel.articles.edit', $sss->article->article_id)}}">
                                    {{$sss->article->article_title}}
                                </a>
                            </td>
                            <td>{{ $sss->sssDetail->question }}</td>
                            <td>{{ $sss->sssDetail->answer }}</td>
                            <td>
                                @if($sss->status)
                                    <span class="badge badge-success">Aktif</span>
                                @else
                                    <span class="badge badge-danger">Pasif</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.sss.delete', $sss->sss_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.sss.edit', $sss->sss_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                                @if($sss->status == 1)
                                    <a href="{{ route('adtrpanel.sss.deactivated', $sss->sss_id) }}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> Pasif Et
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.sss.activated', $sss->sss_id) }}">
                                        <button class="btn btn-dark btn-sm">
                                            <i class="fas fa-lock-open"></i> Aktif Et
                                        </button>
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="5" style="text-align: right;">Seçilileri &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">Seçiniz</option>
                                <option value="sil">Sil</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="9">
                            {{ $ssses->appends(['aranan' => old('aranan')])->links() }}
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">Hiçbir soru bulunamadı</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#sssmanage"]').attr('aria-expanded', 'true');
            $('#sssmanage').addClass('show')
        });
    </script>
@endsection