@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="POST" action="{{ route('post.tweet') }}" enctype="multipart/form-data">
            {{ csrf_field() }}
            @if(count($errors))
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.
                    <br/>
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">Gönderi Paylaşımı</a>
                    </li>

                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>

                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    <!--Genel Bilgiler-->
                    <div class="form-group row">
                        <label for="announcement_title" class="col-sm-2 col-form-label">Gönderi Metni: <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <textarea class="form-control" name="tweet"></textarea>
                        </div>
                    </div>


                    <div class="form-group row">
                        <label for="rank" class="col-sm-2 col-form-label">Resim Yükle:</label>
                        <div class="col-sm-6">
                            <input type="file" name="image" multiple class="form-control">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="rank" class="col-sm-2 col-form-label">Sosyal Medya Hesabı</label>
                         <div class="col-sm-6">
                             <input type="checkbox" name="twitter" value="Bike">Twitter<br>
                         </div>
                    </div>
                    <div class="form-group row">
                        <label for="rank" class="col-sm-2 col-form-label">Yayınlanacağı Tarih</label>
                        <div class="col-sm-6">
                            <input type="datetime-local" name="published_at" >
                        </div>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-success">Gönderi Ekle</button>
                    </div>
                    <!-- Genel Bilgi Bitti -->
                </div>


                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#announcement"]').attr('aria-expanded', 'true');
            $('#announcement').addClass('show')
        });
    </script>
    <script src="/ckeditor/ckeditor.js"></script>
    <script>
        CKEDITOR.replace( 'announcement_content', {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        } );
    </script>
@endsection

