@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="{{ route('adtrpanel.smsgonder.save', $smsSource->sms_id) }}">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> Gönder</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_setting">SMS Sağlayıcı Ayarları</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_setting">SMS Sağlayıcı Ayarları</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_setting">
                    <div class="form-group row">
                        <label for="sms_text" class="col-sm-2 col-form-label">Düzenlenen SMS Sağlayıcı<span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            {{$smsSource->name}}
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="sms_text" class="col-sm-2 col-form-label">SMS Sağlayıcı Durumu<span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <select name="status" class="form-control">
                                <option value="0" @if($smsSource->status == 0) selected="selected" @endif>Bu Sağlayıcı Pasif</option>
                                <option value="1" @if($smsSource->status == 1) selected="selected" @endif>Bu Sağlayıcı Varsayılan Durumda</option>
                            </select>
                        </div>
                    </div>
                    <?php $i = 0 ?>
                    @foreach (json_decode($smsSource->content) as $sourceData)
                    <div class="form-group row">
                        <label for="{{$sourceData->param}}" class="col-sm-2 col-form-label">{{$sourceData->option}}<span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <input type="hidden" name="source[{{$i}}][option]" value="{{$sourceData->option}}" />
                            <input type="hidden" name="source[{{$i}}][param]" value="{{$sourceData->param}}" />
                            <input type="text" name="source[{{$i}}][value]" value="{{$sourceData->value}}" class="form-control" />
                        </div>
                    </div>
                    <?php $i++; ?>
                    @endforeach
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#smssend"]').attr('aria-expanded', 'true');
            $('#smssend').addClass('show');
        });
    </script>
@endsection