@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="{{ route('adtrpanel.smsgonder.send') }}">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> Gönder</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_setting">Toplu SMS Gönder</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_setting">Toplu SMS Gönder</option>

                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_setting">
                    <div class="form-group row">
                        <label for="setting_type" class="col-sm-2 col-form-label">SMS Gönderilecek Numaraların Listesi <span class="required-input">*</span><small class="text-muted">Excel yada txt dosyasından kopyalayıp numaraları toplu halde buraya yapıştırınız.</small></label>
                        <div class="col-sm-10">
                        	<input type="text" name="sms_no_list" id="sms_no_list" class="form-control" required />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="sms_text" class="col-sm-2 col-form-label">Gönderilecek SMS Metni <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <textarea name="sms_text" class="form-control char-textarea" rows="5" maxlength="300"
                                   data-length=300 required></textarea>
                            <span class="char-count">300 </span> <span class="char-count-label">/ 300</span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="sms_time" class="col-sm-2 col-form-label">SMS Gönderim Zamanı <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <select name="sms_time" class="form-control" onchange="smsTime()">
                            	<option value="now">Hemen Gönderilsin</option>
                            	<option value="schedule">Seçeceğim Tarih ve Saatte Gönderilsin</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row" id="sms_schedule_area" style="display: none;">
                        <label for="sms_schedule" class="col-sm-2 col-form-label">SMS Gönderilmesini istediğiniz Tarih ve Saati Giriniz
                        </label>
                        <div class="col-sm-10">
                            <input type="datetime-local" name="sms_schedule" class="form-control" />
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
	<link rel="stylesheet" href="/admin/css/jquery.tagsinput.min.css" />
@endsection
@section('js')
	<script src="/admin/js/jquery.tagsinput.min.js"></script>+
    <script type="text/javascript">
    $('#sms_no_list').tagsInput({
       'height':'100px',
       'width':'100%',
       'defaultText':'Örnek: 5554443322',
       'interactive':true,
       'delimiter': [',',';',' '],   // Or a string with a single delimiter. Ex: ';'
       'removeWithBackspace' : true,
       'minChars' : 0,
       'maxChars' : 0, // if not provided there is no limit
       'placeholderColor' : '#666666'
    });

      $("#sms_no_list_tag").on('paste',function(e){
            var element=this;
            setTimeout(function () {
                var text = $(element).val();
                var target=$("#sms_no_list");
                var tags = (text).split(/[ ,]+/);
                for (var i = 0, z = tags.length; i<z; i++) {
                    var tag = $.trim(tags[i]);
                    var filter = /^[0-9-+]+$/;
                    if (filter.test(tag) && tag.length == 10) {
                        if (!target.tagExist(tag)) {
                            target.addTag(tag);
                        }
                        else
                        {
                            $("#sms_no_list_tag").val('');
                        }
                    }
                    else
                    {
                        $("#sms_no_list_tag").val('');
                    }
                }
            }, 0);
        });
    </script>
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#smssend"]').attr('aria-expanded', 'true');
            $('#smssend').addClass('show');
        });
    </script>
    <script type="text/javascript">
    	function smsTime()
    	{
    		var sms_time = $('select[name=sms_time]').val();
    		if(sms_time == 'schedule')
    		{
    			$('#sms_schedule_area').fadeIn();
    		} else {
    			$('#sms_schedule_area').fadeOut();
    		}
    	}
    </script>
@endsection