@extends('adtrpanel.layouts.master')
@if(isset($sliders))
    @section('title','Slider Düzenle Formu')
@else
    @section('title','Slider Ekle')
    @endif
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="@if(isset($sliders)) {{ route('adtrpanel.sliders.save', $sliders[0]->slider_id) }} @else {{ route('adtrpanel.sliders.save') }} @endif" enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> {{ trans('admin.save') }}</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">{{ trans('admin.general_infos') }}</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#image">Resim</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>
                    <option data-toggle="pill" value="#image">Resim</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    @section('css')
                        <style>
                            .active {display:block!important;}
                        </style>
                    @endsection
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}">
                                        <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @php $a = 0; @endphp
                    @foreach($languages as $language)
                        @php
                            @$sliderX = \App\Models\SliderDetail::where('language_id',$language->language_id)->where('slider_id',$sliders[0]->slider_id)->first();
                        @endphp
                        <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}" style="display: none;" id="{{$language->language_short_name}}">
                            <div class="form-group row">
                                <label for="article_title" class="col-sm-2 col-form-label">Slider Başlığı <span class=" -input">*</span>
                                </label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control char-textarea" name="title[{{$language->language_short_name}}]"   maxlength="100"
                                           data-length=100 id="article_title" placeholder="Slider Başlığı"value="{{ @$sliderX->title }}"/>
                                    <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="article_content" class="col-sm-2 col-form-label">Slider İçeriği <span
                                            class=" -input">*</span></label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" rows="5" id="article_content" name="text[{{$language->language_short_name}}]" placeholder="Slider İçeriği">{{ @$sliderX->text }}</textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="status" class="col-sm-2 col-form-label">{{ trans('admin.status') }}</label>
                                <div class="col-sm-6">
                                    <select id="status" class="form-control" name="slider_status[{{$language->language_short_name}}]">
                                        <option value="0" @if(@$sliderX->slider_status == 0) selected="selected" @endif>{{ trans('admin.passive') }}</option>
                                        <option value="1" @if(@$sliderX->slider_status == 1) selected="selected" @endif>{{ trans('admin.active') }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="rank" class="col-sm-2 col-form-label">{{ trans('admin.rank') }}</label>
                                <div class="col-sm-6">
                                    <input type="text" class="form-control" name="rank[{{$language->language_short_name}}]" id="rank" placeholder="Slider sıra Numarası" value="{{ @$sliderX->rank }}"/>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="rank" class="col-sm-2 col-form-label">Url</label>
                                <div class="col-sm-6">
                                    <input type="text" class="form-control" name="url[{{$language->language_short_name}}]" id="url" placeholder="Slider sıra Numarası" value="{{ @$sliderX->url }}"/>
                                </div>
                            </div>
                        </div>

                @endforeach
                <!-- Genel Bilgi Bitti -->
                </div>
                <div class="tab-pane" id="image">
                    <!--Resim Bilgileri-->
                    <table class="table table-bordered table-hover">
                        <thead>
                        <tr role="row" class="heading">
                            <th width="40%"> Resim </th>
                            <th width="60%"> Mobil Image </th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td class="text-center">
                                <input type="file" name="image" class="form-control"  />
                                <small class="text-muted">800 x 400 piksel olmalıdır.</small>
                                <img src="{{ @$sliders[0]->image }}"  class="img-fluid" />
                            </td>
                            <td class="text-center">
                                <input type="file" name="mobil_image" class="form-control"  />
                                <small class="text-muted">800 x 400 piksel olmalıdır.</small>
                                <img src="{{ @$sliders[0]->mobil_image }}" alt="{{ @$sliders[0]->mobil_image }}" />
                            </td>

                        </tr>
                        </tbody>
                    </table>
                    <!--Resim Bilgileri Bitti-->
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#sliders"]').attr('aria-expanded', 'true');
            $('#sliders').addClass('show')
        });
    </script>
@endsection