@extends('adtrpanel.layouts.master')
@section('title','Slider')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ trans('admin.sliders') }}</h1>
        <div class="col-md-12">
            <div class="form-group">

            </div>
        </div>
        <!--Ürünler-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 3%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 20%;"> {{ trans('admin.slider_image') }}</th>
                    <th style="width: 35%;"> {{ trans('admin.link') }}</th>
                    <th style="width: 5%;"> {{ trans('admin.rank') }}</th>
                    <th style="width: 5%;"> {{ trans('admin.status') }}</th>
                    <th style="width: 30%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="sliderlist">
                @if (count($slider_list) > 0 )
                    @foreach($slider_list as $slider)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td><img src="{{ $slider->image }}" class="img-fluid" alt="{{ $slider->title }}" /></td>
                            <td>{{ $slider->url }}</td>
                            <td>{{ $slider->rank }}</td>
                            <td>
                                @if ($slider->slider_status)
                                    <span class="badge badge-success">{{ trans('admin.active') }}</span>
                                @else
                                    <span class="badge badge-danger">{{ trans('admin.passive') }}</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.sliders.delete', $slider->slider_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> {{ trans('admin.delete') }}
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.sliders.edit', $slider->slider_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> {{ trans('admin.edit') }}
                                    </button>
                                </a>
                                @if ($slider->slider_status)
                                    <a href="{{ route('adtrpanel.sliders.deactivated', $slider->slider_id) }}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> {{ trans('admin.deactivated') }}
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.sliders.activated', $slider->slider_id) }}">
                                        <button class="btn btn-dark btn-sm">
                                            <i class="fas fa-lock-open"></i> {{ trans('admin.activated') }}
                                        </button>
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="5" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="9">
                            {{ $slider_list->links() }}
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">{{ trans('admin.no_slider_found') }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#sliders"]').attr('aria-expanded', 'true');
            $('#sliders').addClass('show')
        });
    </script>
    <script type="text/javascript">
        function kategoriAra(){
            var aranan = $("input[name='aranan']").val();
            if (aranan != '' ) {
                var veriler = 'aranan='+aranan;
                $.ajax({
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "{{ route('adtrpanel.kategoriara') }}",
                    data: veriler,
                    dataType: "text",
                    cache: false,
                    success: function(sonuc){
                        $('#categorylist').html(sonuc);
                    },
                    error: function(xhr, status, error) {
                        alert(xhr.responseText);
                    }
                });
            }
        }
    </script>
@endsection