@extends('adtrpanel.layouts.master')
@section('title','Site Ayarları')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="{{ route('adtrpanel.siteayarlari') }}" enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                    <a href="{{ route('adtrpanel.siteayarlari.newsetting') }}" class="btn btn-success"><i class="fa fa-check"></i> Yeni Ayar Ekle</a>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> Kaydet</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_setting">{{ trans('admin.general_settings') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#social_setting">{{ trans('admin.social_settings') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#site_titles">Meta Titles</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#site_descriptions">Meta Description</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#logo_setting">{{ trans('admin.logo_settings') }}</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_setting">{{ trans('admin.general_settings') }}</option>
                    <option data-toggle="pill" value="#social_setting">{{ trans('admin.social_settings') }}</option>
                    <option data-toggle="pill" value="#site_titles">Meta Titles</option>
                    <option data-toggle="pill" value="#site_titles">Meta Descriptions</option>
                    <option data-toggle="pill" value="#logo_setting">{{ trans('admin.relation_settings') }}</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_setting">
                    <!--Genel Bilgiler-->
                    @foreach($site_settings as $setting)
                        @if ($setting->type == 'genel')
                            @if($setting->entry == 'countdown')
                                <div class="form-group row">
                                    <label for="{{ $setting->entry }}" class="col-sm-3 col-form-label">{{ $setting->option }} </label>
                                    <div class="col-sm-9">
                                        <input type="datetime-local" class="form-control" name="{{ $setting->entry }}" id="{{ $setting->entry }}" value="{{strftime('%Y-%m-%dT%H:%M',$setting->value)}}" />
                                    </div>
                                </div>
                            @elseif($setting->entry != 'themes_dir')
                                @if ($setting->serialized == null)
                                    <div class="form-group row">
                                        <label for="{{ $setting->entry }}" class="col-sm-3 col-form-label">{{ $setting->option }}</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="{{ $setting->entry }}" id="{{ $setting->entry }}" value="{{ $setting->value }}" />
                                        </div>
                                    </div>
                                @elseif($setting->serialized == 'category')
                                    <div class="form-group row">
                                        <label for="{{ $setting->entry }}" class="col-sm-3 col-form-label">{{ $setting->option }}</label>
                                        <div class="col-sm-9">
                                            <select name="{{ $setting->entry }}" class="form-control">
                                                <?php $sdata = \App\Models\Category::all(); ?>
                                                @foreach($sdata as $cat)
                                                    <option value="{{ $cat->category_id }}" @if($setting->value == $cat->category_id) selected="selected" @endif>{{ $cat->category_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                @else
                                    <div class="form-group row">
                                        <label for="{{ $setting->entry }}" class="col-sm-3 col-form-label">{{ $setting->option }}</label>
                                        <div class="col-sm-9">
                                            <select name="{{ $setting->entry }}" class="form-control">
                                                <?php $sdata = unserialize($setting->serialized); ?>
                                                @foreach($sdata as $key => $value)
                                                    <option value="{{ $key }}" @if($setting->value == $key) selected="selected" @endif>{{ $value }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                @endif
                            @else
                                <div class="form-group row">
                                    <label for="{{ $setting->entry }}" class="col-sm-3 col-form-label">{{ $setting->option }}</label>
                                    <div class="col-sm-9">
                                        <select name="{{ $setting->entry }}" class="form-control">
                                            @foreach($themes as $key => $value)
                                                <option value="{{ $value }}" @if($setting->value == $value) selected="selected" @endif>{{ ucwords($value) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                        @endif
                    @endif
                @endforeach
                <!--Genel Bilgi Bitti-->
                </div>
                <!--Sosyal Medya Ayarları-->
                <div class="tab-pane" id="social_setting">
                    <!--Genel Bilgiler-->
                    @foreach($site_settings as $setting)

                        @if ($setting->type == 'social')
                            @if ($setting->serialized == null)
                                @if( ($setting->entry) == 'twitter_consumer_key' )

                                @endif
                                <div class="form-group row">
                                    <label for="{{ $setting->entry }}" class="col-sm-3 col-form-label">{{ $setting->option }}</label>
                                    <div class="col-sm-9">
                                        <input type="text" data-toggle="tooltip" class="form-control" name="{{ $setting->entry }}" id="{{ $setting->entry }}" value="{{ $setting->value }}" />
                                    </div>
                                </div>
                            @elseif($setting->serialized == 'category')
                                <div class="form-group row">
                                    <label for="{{ $setting->entry }}" class="col-sm-3 col-form-label">{{ $setting->option }}</label>
                                    <div class="col-sm-9">
                                        <select name="{{ $setting->entry }}" class="form-control">
                                            <?php $sdata = \App\Models\Category::where('status', 1)->ge(); ?>
                                            @foreach($sdata as $cat)

                                                <option value="{{ $cat->category_id }}" @if($setting->value == $cat->category_id) selected="selected" @endif>{{ $cat->category_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            @else
                                <div class="form-group row">
                                    <label for="{{ $setting->entry }}" class="col-sm-3 col-form-label">{{ $setting->option }}</label>
                                    <div class="col-sm-9">
                                        <select name="{{ $setting->entry }}" class="form-control">
                                            <?php $sdata = unserialize($setting->serialized); ?>
                                            @foreach($sdata as $key => $value)
                                                <option value="{{ $key }}" @if($setting->value == $key) selected="selected" @endif>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                        @endif

                    @endif
                @endforeach

                <!--Genel Bilgi Bittiker-->
                </div>


                <div class="tab-pane" id="site_titles">
                    <!--Genel Bilgiler-->
                    @foreach($site_settings as $setting)

                        @if ($setting->type == 'title')
                            @if ($setting->serialized == null)

                                <div class="form-group row">
                                    <label for="{{ $setting->entry }}" class="col-sm-3 col-form-label">{{ $setting->option }}</label>
                                    <div class="col-sm-9">
                                        <input type="text" data-toggle="tooltip" class="form-control" name="{{ $setting->entry }}" id="{{ $setting->entry }}" value="{{ $setting->value }}" />
                                    </div>
                                </div>
                            @endif
                        @endif
                    @endforeach

                <!--Genel Bilgi Bittiker-->
                </div>

                <div class="tab-pane" id="site_descriptions">
                    <!--Genel Bilgiler-->
                    @foreach($site_settings as $setting)
                        @if ($setting->type == 'description')
                            @if ($setting->serialized == null)

                                <div class="form-group row">
                                    <label for="{{ $setting->entry }}" class="col-sm-3 col-form-label">{{ $setting->option }}</label>
                                    <div class="col-sm-9">
                                        <input type="text" data-toggle="tooltip" class="form-control" name="{{ $setting->entry }}" id="{{ $setting->entry }}" value="{{ $setting->value }}" />
                                    </div>
                                </div>
                        @endif
                    @endif
                @endforeach

                <!--Genel Bilgi Bittiker-->
                </div>
                <!--Sosyal Medya Ayarları Bitti-->
                <!--Limit Ayarları-->
                <div class="tab-pane" id="limit_setting">
                    @foreach($site_settings as $setting)
                        @if ($setting->type == 'limit')
                            @if ($setting->serialized == null)
                                <div class="form-group row">
                                    <label for="{{ $setting->entry }}" class="col-sm-4 col-form-label">{{ $setting->option }}</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="{{ $setting->entry }}" id="{{ $setting->entry }}" value="{{ $setting->value }}" />
                                    </div>
                                </div>
                            @elseif($setting->serialized == 'category')
                                <div class="form-group row">
                                    <label for="{{ $setting->entry }}" class="col-sm-3 col-form-label">{{ $setting->option }}</label>
                                    <div class="col-sm-9">
                                        <select name="{{ $setting->entry }}" class="form-control">
                                            <?php $sdata = \App\Models\Category::all(); ?>
                                            @foreach($sdata as $cat)
                                                <option value="{{ $cat->category_id }}" @if($setting->value == $cat->category_id) selected="selected" @endif>{{ $cat->category_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            @else
                                <div class="form-group row">
                                    <label for="{{ $setting->entry }}" class="col-sm-4 col-form-label">{{ $setting->option }}</label>
                                    <div class="col-sm-8">
                                        <select name="{{ $setting->entry }}" class="form-control">
                                            <?php $sdata = unserialize($setting->serialized); ?>
                                            @foreach($sdata as $key => $value)
                                                <option value="{{ $key }}" @if($setting->value == $key) selected="selected" @endif>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            @endif
                        @endif
                    @endforeach
                </div>
                <!--İlişki Ayarları-->

                <!--Logo Ayarları-->
                <div class="tab-pane" id="logo_setting">
                    @foreach($site_settings as $setting)
                        @if ($setting->type == 'image')
                            <div class="form-group row">
                                <label for="{{$setting->entry}}" class="col-sm-3 col-form-label">{{ $setting->option }}</label>
                                <div class="col-sm-5">
                                    <input type="file" class="form-control" name="{{$setting->entry}}" id="{{$setting->entry}}" />
                                </div>
                                <div class="col-sm-4">
                                    <img src="{{$setting->value}}" alt="{{$setting->option}}" class="img-responsive" />
                                </div>
                            </div>
                        @endif
                    @endforeach

                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
@endsection