@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">

        <div class="col-12">
            <div class="row">
                <div class="col-6">
                    <h1 class="inner-page-title d-none d-sm-none d-lg-block">Şikayet Çözüm Sistemi</h1>
                </div>
                <div class="col-6 text-right">
                    <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#yeniSikayet">
                        Yeni Şikayet Ekle
                    </button>
                </div>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover text-center">
                <thead>
                <tr>
                    <th style="width: 10%;">Ad Soyad</th>
                    <th style="width: 10%;">Telefon</th>
                    <th style="width: 50%;">Konu</th>
                    <th style="width: 10%;">Şikayet Tarihi</th>
                    <th style="width: 10%;">Durumu</th>
                    <th style="width: 10%;">İşlemler</th>
                </tr>
                </thead>
                <tbody id="pagelist">
                @if(!empty($complaints) && count($complaints) > 0)
                    @foreach($complaints as $complaint)
                        <tr id="sikayet_row_{{ $complaint->complaint_id }}">
                            <td>{{ $complaint->name }}</td>
                            <td>{{ $complaint->phone }}</td>
                            <td>{{ $complaint->subject }}</td>
                            <td>{{
                             \Carbon\Carbon::setLocale('tr').
                             \Carbon\Carbon::parse($complaint->created_at)->diffForHumans() }}</td>
                            <td>
                                @if($complaint->status == "pending")
                                    <span class="badge badge-info">Beklemede</span>
                                @elseif($complaint->status == "active")
                                    <span class="badge badge-primary">Aktif</span>

                                @else
                                    <span class="badge badge-success">Sorun Çözüldü</span>

                                @endif
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.sikayet-takip.show',$complaint->complaint_id) }}"
                                   class="btn btn-success btn-sm"><i
                                            class="fa fa-edit"></i></a>
                                <button type="button" onclick="confirmDelete({{ $complaint->complaint_id }})"
                                        class="btn btn-sm btn-danger">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    @endforeach
                @endif
                </tbody>
            </table>
        </div>
    </section>
    <!--Sayfa İçeriği Bitti-->
    <div class="modal fade" id="yeniSikayet" tabindex="-1" role="dialog" aria-labelledby="yeniSikayet"
         aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <form method="post" id="newComplaints">
                <div class="modal-content">

                    <div class="modal-body">

                        @csrf
                        <div class="form-group text-center">
                            <h3>Yeni Şikayet Ekleme</h3>
                        </div>
                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Ad Soyad* :
                            </label>
                            <div class="col-sm-8">
                                <input type="text" required name="name" placeholder="Ad Soyad" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="phone" class="col-sm-4 col-form-label">Telefon :
                            </label>
                            <div class="col-sm-8">
                                <input type="text" required max="20" name="phone" placeholder="Telefon"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="phone" class="col-sm-4 col-form-label">Şikayet Konusu* :
                            </label>
                            <div class="col-sm-8">
                                <input type="text" required max="200" name="subject" placeholder="Konu"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="detail" class="col-sm-4 col-form-label">Şikayet Detayı* :
                            </label>
                            <div class="col-sm-8">
                                <textarea class="form-control"
                                          required
                                          placeholder="Şikayet Detayları"
                                          name="detail"></textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="note" class="col-sm-4 col-form-label">Şikayet Notu :
                            </label>
                            <div class="col-sm-8">
                                <textarea class="form-control"
                                          placeholder="Şikayet Detayları"
                                          name="note"></textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="note" class="col-sm-4 col-form-label">Şikayet Durumu :
                            </label>
                            <div class="col-sm-8">
                                <select name="status" class="form-control">
                                    <option value="pending">Beklemede</option>
                                    <option value="aktive">Aktif</option>
                                    <option value="complate">Şikayet Çözüldü</option>
                                </select>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" id="mysavebtn" onclick="newComplaints()" class="btn btn-primary">Yeni
                            Şikayet Ekle
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('css')
@endsection
@section('js')

    <script>

        function newComplaints() {

            var form = $('#newComplaints').serialize();
            $('#mysavebtn').attr('disabled', 'disabled');
            $.ajax({
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('adtrpanel.sikayet-takip.yeni-sikayet') }}",
                data: form,
                dataType: "json",
                cache: false,
                success: function (response) {

                    if (response.result == 'success') {

                        window.location = response.redirect_url;
                    } else {
                        $('#mysavebtn').removeAttr('disabled', 'disabled');
                        Swal.fire({
                            position: 'top',
                            type: 'error',
                            title: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        })
                    }

                },
                error: function (xhr, status, error) {
                    alert(xhr.responseText);
                }
            });
        }


        function confirmDelete(id) {
            Swal.fire({
                title: 'Şikayeti Silmek Üzerisiniz.',
                text: "Şikayeti Silmek İstediğinize Eminmisiniz?",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Evet Sil',
                cancelButtonText: 'İptal'
            }).then((result) => {
                $.ajax({
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "{{ route('adtrpanel.sikayet-takip.delete') }}",
                    data: {'id': id},
                    dataType: "json",
                    cache: false,
                    success: function (response) {

                        if (response.result == 'success') {
                            $('#sikayet_row_' + response.id).remove();
                        }

                    },
                    error: function (xhr, status, error) {
                        alert(xhr.responseText);
                    }
                });
            })

        }
    </script>
@endsection