@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post">
            {{ csrf_field() }}

            <input type="hidden" name="language_id" value="{{ request()->segment('5') }}">

            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#group_info">Genel Bilgiler</a>
                    </li>

                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#group_info">Genel Bilgiler</option>

                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="group_info">
                    <!--Genel Bilgiler-->
                    <div class="col-7">
                        <form method="post">
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Ad Soyad:
                                </label>
                                <div class="col-sm-8">
                                    <input type="text" name="name" value="{{ $complaint->name }}" disabled
                                           class="form-control">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Telefon :
                                </label>
                                <div class="col-sm-8">
                                    <input type="text" value="{{ $complaint->phone }}" disabled name="phone"
                                           class="form-control">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Şikayet Konusu :
                                </label>
                                <div class="col-sm-8">
                                    <input type="text" value="{{ $complaint->subject }}"  disabled  name="subject"
                                           class="form-control">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Şikayet Detayı :
                                </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="detail">{{ $complaint->detail }}</textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">İşlem Notu :
                                </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note">{{ $complaint->note }}</textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Şikayet Tarihi :
                                </label>
                                <div class="col-sm-8">
                                    {{ \Carbon\Carbon::parse($complaint->created_at)->format('d-m-Y H:i:s') }}
                                    <br>
                                   {{
                                   \Carbon\Carbon::setLocale('tr').
                             \Carbon\Carbon::parse($complaint->created_at)->diffForHumans()
                                   }}
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">İşlem Notu :
                                </label>
                                <div class="col-sm-8">
                                    <select name="status" class="form-control">
                                        <option @if($complaint->status == "pending") selected @endif value="pending">Beklemede</option>
                                        <option @if($complaint->status == "aktive") selected @endif value="aktive">Aktif</option>
                                        <option @if($complaint->status == "complate") selected @endif value="complate">Şikayet Çözüldü</option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">

                                <div class="col-sm-10 text-right">
                                    <button class="btn btn-primary" type="submit">Kaydet</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </form>
        <hr>
    </section>

@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#complaints"]').attr('aria-expanded', 'true');
            $('#complaints').addClass('show')
        });
    </script>

    <script>

    </script>
@endsection