@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Projeler</h1>
        <div class="col-md-12">
            <div class="form-group">
                <input type="text" name="aranan" id="aranan" class="form-control" placeholder="Aradığınız Proje Sayfası Başlığını Giriniz" value="{{ old('aranan')}}" onkeyup="projeAra()" />
            </div>
        </div>
        <!--Ürünler-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 15%;"> Proje Görseli</th>
                    <th style="width: 35%;"> Proje Başlığı</th>
                    <th style="width: 10%;"> {{ trans('admin.rank') }}</th>
                    <th style="width: 5%;"> {{ trans('admin.status') }}</th>
                    <th style="width: 30%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="projectlist">
                @if (count($project_list) > 0 )
                    @foreach($project_list as $project)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td><img src="{{ $project->projectDetail->image }}" class="img-responsive" alt="{{ $project->projectDetail->alt_and_title }}" width="250" /></td>
                            <td>{{ $project->project_title }}</td>
                            <td>{{ $project->rank }}</td>
                            <td>
                                @if($project->status)
                                    <span class="badge badge-success">{{ trans('admin.active') }}</span>
                                @else
                                    <span class="badge badge-danger">{{ trans('admin.passive') }}</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.projects.delete', $project->project_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.projects.edit', $project->project_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                                @if($project->status)
                                    <a href="{{ route('adtrpanel.projects.deactivated', $project->project_id) }}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> {{ trans('admin.deactivated') }}
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.projects.activated', $project->project_id) }}">
                                        <button class="btn btn-dark btn-sm">
                                            <i class="fas fa-lock-open"></i> {{ trans('admin.activated') }}
                                        </button>
                                    </a>
                                @endif
                                <a href="" target="_blank">
                                    <button class="btn btn-primary btn-sm">
                                        <i class="fa fa-eye"></i> Görüntüle
                                    </button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="5" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="6">
                            {{ $project_list->appends(['aranan' => old('aranan')])->links() }}
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">Hiçbir proje bulunamadı</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#project"]').attr('aria-expanded', 'true');
            $('#project').addClass('show')
        });
    </script>
    <script type="text/javascript">
        function  projeAra(){
            var aranan = $("input[name='aranan']").val();
            //if (aranan != '' ) {
            var veriler = 'aranan='+aranan;
            $.ajax({
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('adtrpanel.haberara') }}",
                data: veriler,
                dataType: "text",
                cache: false,
                success: function(sonuc){
                    $('#projectlist').html(sonuc);
                },
                error: function(xhr, status, error) {
                    alert(xhr.responseText);
                }
            });
            //}
        }
    </script>
@endsection