@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="@if(isset($project)) {{ route('adtrpanel.projects.save', $project->project_id) }} @else {{ route('adtrpanel.projects.save') }} @endif" enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> {{ trans('admin.save') }}</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">{{ trans('admin.general_infos') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#meta_info">{{ trans('admin.meta_infos') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#details_info">{{ trans('admin.detail_infos') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#image">Resim</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>
                    <option data-toggle="pill" value="#meta_info">{{ trans('admin.meta_infos') }}</option>
                    <option data-toggle="pill" value="#details_info">{{ trans('admin.detail_infos') }}</option>
                    <option data-toggle="pill" value="#image">Resim</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    <!--Genel Bilgiler-->
                    <div class="form-group row">
                        <label for="project_title" class="col-sm-2 col-form-label">Proje Başlığı <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control char-textarea" name="project_title" required maxlength="100"
                                   data-length=100 id="project_title" placeholder="Proje Başlığı" @if(isset($project)) value="{{ $project->project_title }}" @endif />
                            <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="project_content" class="col-sm-2 col-form-label">Proje İçeriği <span
                                    class="required-input">*</span></label>
                        <div class="col-sm-10">
                            <textarea class="form-control" rows="5" id="project_content" name="project_content" placeholder="Proje İçeriği"> @if(isset($project)) {{ $project->project_content }} @endif </textarea>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="status" class="col-sm-2 col-form-label">{{ trans('admin.status') }}</label>
                        <div class="col-sm-6">
                            <select id="status" class="form-control" name="status">
                                <option value="0" @if(isset($project) && $project->status == 0) selected="selected" @endif>{{ trans('admin.passive') }}</option>
                                <option value="1" @if(isset($project) && $project->status == 1) selected="selected" @endif>{{ trans('admin.active') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="rank" class="col-sm-2 col-form-label">{{ trans('admin.rank') }}</label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" name="rank" id="rank" placeholder="Sayfa sıra Numarası" @if(isset($project)) value="{{ $project->rank }}" @endif />
                        </div>
                    </div>
                    <!-- Genel Bilgi Bitti -->
                </div>
                <div class="tab-pane" id="meta_info">
                    <!--Meta Bilgileri-->
                    <div class="form-group row">
                        <label for="project_meta_title" class="col-sm-2 col-form-label">{{ trans('admin.meta_title') }}
                        </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control char-textarea" name="project_meta_title" required maxlength="100"
                                   data-length=100 id="project_meta_title" placeholder="Proje Meta Başlığı" @if(isset($project)) value="{{ $project->projectDetail->project_meta_title }}" @endif />
                            <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="project_meta_description" class="col-sm-2 col-form-label">{{ trans('admin.meta_description') }} </label>
                        <div class="col-sm-10">
                            <textarea class="form-control" rows="5" id="project_meta_description" name="project_meta_description" placeholder="Proje Meta Açıklaması"> @if(isset($project)) {{ $project->projectDetail->project_meta_description }} @endif </textarea>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="project_meta_keywords" class="col-sm-2 col-form-label">{{ trans('admin.meta_keywords') }} </label>
                        <div class="col-sm-10">
                            <textarea class="form-control" rows="5" id="project_meta_keywords" name="project_meta_keywords" placeholder="Proje Meta Keywords"> @if(isset($project)) {{ $project->projectDetail->project_meta_keywords }} @endif </textarea>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="slug" class="col-sm-2 col-form-label">Proje SEO Urlsi <i class="fas fa-question-circle info-circle" data-html="true" data-toggle="tooltip" data-placement="right" title="Projeye özel url tanımlamak isterseniz bu alanı doldurunuz.<br />Örn: yazi-basligi-ozel-url<br />Boş bırakırsanız proje başlığı SEO URL ye dönüştürülecektir."></i></label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" name="slug" id="slug" placeholder="Proje SEO Urlsi" @if(isset($project)) value="{{ $project->slug }}" @endif />
                        </div>
                    </div>
                    <!--Meta Bilgileri Bitti-->
                </div>
                <div class="tab-pane" id="details_info">
                    <!--Detay Bilgileri-->
                    <div class="form-group row">
                        <label for="footer_status" class="col-sm-2 col-form-label">Footerda Gözüksün
                        </label>
                        <div class="col-sm-6">
                            <select id="footer_status" class="form-control" name="footer_status">
                                <option value="0" @if(isset($project) && $project->projectDetail->footer_status == 0) selected="selected" @endif>{{ trans('admin.no') }}</option>
                                <option value="1" @if(isset($project) && $project->projectDetail->footer_status == 1) selected="selected" @endif>{{ trans('admin.yes') }}</option>
                            </select>
                        </div>
                    </div>
                    <!--Detay Bilgileri Bitti-->
                </div>
                <div class="tab-pane" id="image">
                    <!--Resim Bilgileri-->
                    <table class="table table-bordered table-hover">
                        <thead>
                        <tr role="row" class="heading">
                            <th width="40%"> Resim </th>
                            <th width="60%"> Resim Alt ve Title Tagı Bilgisi </th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td class="text-center">
                                <input type="file" name="image" class="form-control"  />
                                <small class="text-muted">800 x 400 piksel olmalıdır.</small>
                                @if(isset($project))
                                    <img src="{{ $project->projectDetail->image }}" alt="{{ $project->projectDetail->alt_and_title }}" class="img-responsive" />
                                @endif
                            </td>
                            <td>
                                <input type="text" name="alt_and_title" value="@if(isset($project)) {{ $project->projectDetail->alt_and_title }} @endif" class="form-control char-textarea" placeholder="" maxlength="100" data-length="100"  />
                                <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <!--Resim Bilgileri Bitti-->
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#project"]').attr('aria-expanded', 'true');
            $('#project').addClass('show')
        });
    </script>
    <script src="/ckeditor/ckeditor.js"></script>
    <script>
        CKEDITOR.replace( 'project_content', {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        } );
    </script>
@endsection