@extends('adtrpanel.layouts.master')
@section('title','Ürün Düzenleme Formu')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post"
              action="@if(isset($product)) {{ route('adtrpanel.product.save', $product[0]->id) }} @else {{ route('adtrpanel.product.save') }} @endif"
              enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}">
                        <button type="button" name="back" class="btn btn-secondary-outline"><i
                                    class="fa fa-angle-left"></i> Geri
                        </button>
                    </a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i>
                        Kaydet
                    </button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">Genel Bilgiler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#data">Veri</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link " data-toggle="pill" href="#image">
                            Resim</a>
                    </li>
                </ul>

            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">Genel Bilgiler</option>
                    <option value="#data">Veri</option>
                    <option value="#image">Resim</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @section('css')
                                <style>
                                    .active {
                                        display: block !important;
                                    }
                                </style>
                            @endsection
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}"
                                       data-toggle="pill" href="#{{$language->language_short_name}}">
                                        <img class="img-thumbnail rounded mx-auto d-block"
                                             src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px"
                                           class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <!--Genel Bilgiler-->
                    @php $a = 0; @endphp
                    @foreach($languages as $language)
                        @php
                            //   @$photoGalleryDetail = \App\Models\PhotoGalleryDetail::where('language_id',$language->language_id)->where('photo_gallery_id',$gallery[0]->photo_gallery_id)->first();
                        @endphp

                        <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}"
                             style="display: none;" id="{{$language->language_short_name}}">
                            <div class="form-group row">
                                <label for="product_name" class="col-sm-2 col-form-label" >Ürün Adı <span
                                            class="required-input">*</span>
                                </label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control char-textarea" required="required"
                                           name="product_name[{{$language->language_short_name}}]" maxlength="100"
                                           data-length=100 id="product_name" placeholder="Ürün Adı"
                                           @if(isset($product)) value="{{ @$product[0]->name }}" @endif />
                                    <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="product_description" class="col-sm-2 col-form-label">Ürün Açıklaması <span
                                            class="required-input">*</span></label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" rows="5" id="product_description" required="required"
                                              name="product_description[{{$language->language_short_name}}]"
                                              placeholder="Ürün Açıklaması">@if(isset($product)) {{@$product[0]->description}} @endif</textarea>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="meta_title" class="col-sm-2 col-form-label">Meta Title <span
                                            class="required-input">*</span>
                                </label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control char-textarea"
                                           name="meta_title[{{$language->language_short_name}}]" maxlength="100"
                                           data-length=100 id="meta_title" placeholder="Meta Başlığı"
                                           @if(isset($product)) value="{{ @$product[0]->meta_title }}" @endif />
                                    <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="meta_description" class="col-sm-2 col-form-label">Meta Açıklama <span
                                            class="required-input">*</span>
                                </label>

                                <div class="col-sm-10">
                                    <textarea class="form-control" rows="5" id="meta_description" required="required"
                                              name="meta_description[{{$language->language_short_name}}]"
                                              placeholder="Meta Açıklaması">@if(isset($product)) {{@$product[0]->meta_description}} @endif</textarea>
                                </div>

                            </div>
                            <div class="form-group row">
                                <label for="slug" class="col-sm-2 col-form-label">Seo Url <span
                                            class="required-input">*</span>
                                </label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control char-textarea" required="required"
                                           name="slug[{{$language->language_short_name}}]" maxlength="150"
                                           data-length=150 id="slug" placeholder="Seo Url"
                                           @if(isset($product)) value="{{ @$product[0]->slug }}" @endif />
                                    <span class="char-count">150 </span> <span class="char-count-label">/ 150</span>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="seo_description" class="col-sm-2 col-form-label">Seo Acıklaması <span
                                            class="required-input">*</span>
                                </label>
                                <div class="col-sm-10">
                                    <textarea rows="5" class="form-control char-textarea" required="required" name="seo_description[{{$language->language_short_name}}]" placeholder="Seo Acıklaması">{{ @$product[0]->seo_description }}</textarea>
                                </div>
                            </div>

                            @if(isset($product))
                                <div class="form-group row" style="display: none">
                                    <label for="slug" class="col-sm-2 col-form-label">Galeri Kısa Kodu
                                        <i class="fas fa-question-circle info-circle" data-html="true"
                                           data-toggle="tooltip" data-placement="right"
                                           title="Galeriyi kendi oluşturacağınız sayfalarda kullanabilmeniz için gereken kod parçacığıdır.."></i>
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control"
                                               value="[video-galeri-id={{@$product[0]->id}}]" readonly/>
                                    </div>
                                </div>
                            @endif
                        </div>
                    @php $a++; @endphp
                @endforeach
                <!--Genel Bilgi Bittiker-->
                </div>

                <div class="tab-pane" id="data">
                    @php $a = 0; @endphp
                    @foreach($languages as $language)

                        <div class="form-group row">
                            <label for="model" class="col-sm-2 col-form-label">Ürün Kodu
                            </label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control char-textarea"
                                       name="model[{{$language->language_short_name}}]" maxlength="100"
                                       data-length=100 id="model" placeholder="Ürün Kodu"
                                       @if(isset($product)) value="{{ @$product[0]->model }}" @endif />
                                <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="price" class="col-sm-2 col-form-label">Fiyat</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control"
                                       name="price[{{$language->language_short_name}}]"
                                       id="price" placeholder="Fiyat"
                                       @if(isset($product)) value="{{ @$product[0]->price }}" @endif />

                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="status" class="col-sm-2 col-form-label">Durum</label>
                            <div class="col-sm-10">
                                <select id="status" class="form-control"
                                        name="status[{{$language->language_short_name}}]">
                                    <option value="0"
                                            @if(isset($product) && @$product[0]->status == 0) selected="selected" @endif>
                                        Pasif
                                    </option>
                                    <option value="1"
                                            @if(isset($product) && @$product[0]->status == 1) selected="selected" @endif>
                                        Aktif
                                    </option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="input-category"><span data-toggle="tooltip"
                                                                                              title=""
                                                                                              data-original-title="(Autocomplete)">Kategoriler</span></label>
                            <div class="col-sm-10">
                                <input type="text" name="category" value="" placeholder="Kategoriler"
                                       id="input-category" class="form-control" autocomplete="off">
                                <ul class="dropdown-menu" style="top: 36px; left: 15px; display: none;">
                                    <li data-value="33"><a href="#">Cameras</a></li>
                                    <li data-value="25"><a href="#">Components</a></li>
                                    <li data-value="29"><a href="#">Components&nbsp;&nbsp;&gt;&nbsp;&nbsp;Mice and
                                            Trackballs</a></li>
                                    <li data-value="28"><a href="#">Components&nbsp;&nbsp;&gt;&nbsp;&nbsp;Monitors</a>
                                    </li>
                                    <li data-value="35"><a href="#">Components&nbsp;&nbsp;&gt;&nbsp;&nbsp;Monitors&nbsp;&nbsp;&gt;&nbsp;&nbsp;test
                                            1</a></li>
                                </ul>
                                <div id="product-category" class="well well-sm"
                                     style="height: 150px; overflow: auto;background: gainsboro">

                                    @if(!empty($categories))
                                        @foreach($categories as $category)

                                            <div id="product-category{{ $category['category_id'] }}"><i
                                                        class="fa fa-minus-circle"></i> {{ $category['category_name'] }}
                                                <input type="hidden" name="product_category[]"
                                                       value="{{ $category['category_id'] }}"/>
                                            </div>

                                        @endforeach
                                    @endif

                                </div>
                            </div>
                        </div>

                        @php $a++; @endphp
                    @endforeach
                </div>
                <div class="tab-pane" id="image">
                    <!--Resim Bilgileri-->
                    <table class="table table-bordered table-hover">
                        <thead>
                        <tr role="row" class="heading">
                            <th width="40%"> Resim</th>
                            <th width="60%"> Resim Alt ve Title Tagı Bilgisi</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td class="text-center">
                                <input type="file" name="image"
                                       value="<?php isset($product[0]->image) ? $product[0]->image : '' ?> "
                                       class="form-control"/>
                                <small class="text-muted">800 x 400 piksel olmalıdır.</small>
                                <img src="/{{ @$product[0]->image }}" alt="" class="img-responsive"/>
                            </td>
                            <td>
                                <input type="text" name="alt_and_title" value="{{ @$product[0]->alt_and_title }}" class="form-control char-textarea"
                                       placeholder="" maxlength="100" data-length="100"/>
                                <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                            </td>
                        </tr>
                        </tbody>
                    </table>

                    <div class="table-responsive">
                        <table id="images" class="table table-striped table-bordered table-hover">
                            <thead>
                            <tr>
                                <td class="text-left">Resim Ekle</td>
                                <td class="text-right">Sort Order</td>
                                <td></td>
                            </tr>
                            </thead>
                            <tbody>

                            @php
                                $count = 0;
                            @endphp
                            @if(isset($productImages))
                                @foreach($productImages as $key=>$image)
                                    <tr id="image-row{{ $image->id }}">

                                        <td class="text-left">
                                            <img src="/{{$image->image}}" alt="" title="" data-placeholder=""
                                                 style="float:left" width="150" height="150"/>
                                            <input type="hidden" name="product_image[{{$key}}][image]"
                                                   value="{{$image->image}}" id="input-image{{$key}}"/>
                                        </td>

                                        <td class="text-right">
                                            <input type="text" name="product_image[{{$key}}][sort_order]" value=""
                                                   placeholder="Sort Order" class="form-control"/>
                                        </td>

                                        <td class="text-left">
                                            <button type="button" onclick="deleteImage({{ $image->id }})"
                                                    title="Sil" class="btn btn-danger">
                                                <i class="fa fa-minus-circle"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    @php
                                        $count++;
                                    @endphp
                                @endforeach
                            @endif

                            </tbody>
                            <tfoot>
                            <tr>
                                <td colspan="2"></td>
                                <td class="text-left">
                                    <button type="button" onclick="addImage()" title="Resim Ekle"
                                            class="btn btn-primary"><i class="fa fa-plus-circle"></i></button>
                                </td>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!--Resim Bilgileri Bitti-->
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
    <link rel="stylesheet"  href="https://cdnjs.cloudflare.com/ajax/libs/jquery-autocomplete/1.0.7/jquery.auto-complete.css"/>
@endsection
@section('js')
    <script src="/admin/js/autocomplete.js"></script>
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#product"]').attr('aria-expanded', 'true');
            $('#product').addClass('show')
        });
    </script>



    <script>
        var image_row = <?php echo $count;?>

        function addImage() {
            html = '<tr id="image-row' + image_row + '">';
            html += '  <td class="text-left"><input type="file" name="product_image[' + image_row + ']" class="form-control"  /><small class="text-muted">800 x 400 piksel olmalıdır.</small><img src="" alt="" title="" data-placeholder="" /></a><input type="hidden" name="product_image[' + image_row + '][image]" value="" id="input-image' + image_row + '" /></td>';
            html += '  <td class="text-right"><input type="text" name="product_image[' + image_row + '][sort_order]" value="" placeholder="Sort Order" class="form-control" /></td>';
            html += '  <td class="text-left"><button type="button" onclick="$(\'#image-row' + image_row + '\').remove();" data-toggle="tooltip" title="Sil" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>';
            html += '</tr>';

            $('#images tbody').append(html);

            image_row++;
        }
    </script>

    <script>
      function deleteImage(id) {
          $("#image-row" + id).remove();
          $.ajax({
              type: 'post',
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              url: '{{route('adtrpanel.product.ajax')}}',
              data: {id: id},
              dataType: 'json',
              cache: false,
              success: function (response) {
                  console.info(id);
                  if (response.result == "success"){


                  }
              }
          });
      }

    </script>


    <script>
        // Category
        $('input[name=\'category\']').autocomplete({
            'source': function (request, response) {
                console.log(request);
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: '{{route('adtrpanel.categories.all')}}',
                    data: {'filter_name': request},
                    dataType: 'json',
                    success: function (json) {
                        response($.map(json, function (item) {
                            return {
                                label: item['name'],
                                value: item['category_id']
                            }
                        }));
                    }
                });
            },
            'select': function (item) {
                $('input[name=\'category\']').val('');

                $('#product-category' + item['value']).remove();

                $('#product-category').append('<div id="product-category' + item['value'] + '"><i class="fa fa-minus-circle"></i> ' + item['label'] + '<input type="hidden" name="product_category[]" value="' + item['value'] + '" /></div>');
            }
        });

        $('#product-category').delegate('.fa-minus-circle', 'click', function () {
            $(this).parent().remove();
        });
    </script>
    <script src="/ckeditor/ckeditor.js"></script>
    <script>
        var editorConfig = {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        };
        @foreach($languages as $language)
        CKEDITOR.replace('product_description[{{$language->language_short_name}}]', editorConfig);
        @endforeach

    </script>
@endsection