@extends('adtrpanel.layouts.master')
@section('title','Ürünler Listesi')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">{{ 'Ürün Listesi' }}</h1>
        <div class="text-right">
            <div class="actions btn-set">
                <a href="{{ route('adtrpanel.product.edit') }}" class="btn btn-success"><i class="fa fa-check"></i> Yeni Ürün Ekle</a>
            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <input type="text" name="name" id="" class="form-control" placeholder="Aradığınız Ürünün Başlığını Giriniz" value="" onkeyup="productSearch()">
            </div>
        </div>
        <!--Ürünler-->
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 30%;"> {{ trans('Ürün adi') }}  <a style="float: right;font-size: 16px;cursor: pointer" class="product_top" title="A-Z'ye sırala">&uarr;</a> <a style="float: right;display: none;font-size: 16px;cursor:pointer" class="product_bottom" title="Z-A'ya sırala">&darr;</a> </th>
                    <th style="width: 10%;"> {{ trans('Ürün Kodu') }}</th>
                    <th style="width: 10%;"> {{ trans('Ürün Fiyatı') }}</th>
                    <th style="width: 10%;"> {{ trans('admin.status') }}</th>
                    <th style="width: 30%;"> {{ trans('admin.actions') }}</th>
                </tr>
                </thead>
                <tbody id="product" class="product_tbody">
                @if (count($products) > 0 )
                    @foreach($products as $product)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>{{ $product->name }}</td>

                            <td>{{ $product->model }}</td>
                            <td>{{ $product->price }}</td>
                            <td>
                                @if($product->status)
                                    <span class="badge badge-success">{{ trans('admin.active') }}</span>
                                @else
                                    <span class="badge badge-danger">{{ trans('admin.passive') }}</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.product.delete', $product->id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.product.edit', $product->id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                                @if($product->status)
                                    <a href="{{ route('adtrpanel.product.deactivated', $product->id) }}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> {{ trans('admin.deactivated') }}
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.product.activated', $product->id) }}">
                                        <button class="btn btn-dark btn-sm">
                                            <i class="fas fa-lock-open"></i> {{ trans('admin.activated') }}
                                        </button>
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="5" style="text-align: right;">{{ trans('admin.selected_for') }} &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">{{ trans('admin.choose') }}</option>
                                <option value="sil">{{ trans('admin.delete') }}</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="6">
                            <?php /*{{ $product->appends(['aranan' => old('aranan')])->links() }} */?>
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="6">{{ trans('admin.no_galeries_found') }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#product"]').attr('aria-expanded', 'true');
            $('#product').addClass('show')
        });
    </script>
    
    <script type="text/javascript">
    function productSearch() {
        var name   = $("input[name='name']").val();
        var _token = '{{ csrf_token() }}';
       $.ajax({
          type     :'post',
          url      :'{{route('adtrpanel.product.search')}}',
          data     :{_token:_token,name:name},
          dataType :'text',
          cache    :false,
          success  :function (response) {
              if(response != '')
                $('.product_tbody').html(response);
              else
                $('.product_tbody').html('<td colspan="6" style="text-align: center"> Sonuc Bulunamadı</td>')
          },
          errors:function(xhr,status,error){
              alert(xhr.responseText);
          }
       });
    }    
    </script>

    <script type="text/javascript">
        $('.product_top').click(function () {
            $('.product_top').css({'display':'none'});
            $('.product_bottom').css({'display':'block'});
            //a-z

            orderName(1);
        });

        $('.product_bottom').click(function () {
            $('.product_bottom').css({'display':'none'});
            $('.product_top').css({'display':'block'});
            //z-a

            orderName(0);
        });

        function orderName(order) {
            var _token = '{{csrf_token()}}';
            $.ajax({
              type:'post',
              url:'{{route('adtrpanel.product.name.order')}}',
              data:{order:order,_token:_token},
              dataType:'text',
              success:function (response) {
                  $('.product_tbody').html(response);
              }

            });
        }

    </script>
    
@endsection