@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Sanal Pos - Gelen Ödeme - {{ $payment->name }}</h1>

        <div style="border: solid 1px #919191" class="row col-6 offset-3">
            <div class="form-group row col-12 ">
                <div class="text-center">
                    <h2>Ödeme Bilgileri</h2>
                </div>
            </div>
            <div class="form-group row col-12">
                <label for="merchant_key" class="col-md-4 text-right col-form-label">Sipariş No
                    :</label>
                <div class="col-md-6">
                    <strong>{{ $payment->order_id }}</strong>
                </div>
            </div>
            @if(!empty($payment->transaction_id))
                <div class="form-group row col-12">
                    <label for="merchant_key" class="col-md-4 text-right col-form-label">Banka İşlem No
                        :</label>
                    <div class="col-md-6">
                        <strong>{{ $payment->transaction_id }}</strong>
                    </div>
                </div>
            @endif

            <div class="form-group row col-12">
                <label for="merchant_key" class="col-md-4 text-right col-form-label">Ad ve Soyadınız
                    :</label>
                <div class="col-md-6">
                    <strong>{{ $payment->name }}</strong>
                </div>
            </div>
            <div class="form-group row col-12">
                <label for="merchant_key" class="col-md-4 text-right col-form-label">Telefon
                    :</label>
                <div class="col-md-6">
                    {{ $payment->phone }}
                </div>
            </div>
            <div class="form-group row col-12">
                <label for="merchant_key" class="col-md-4 text-right col-form-label">Not
                    :</label>
                <div class="col-md-6">
                    {{ $payment->note }}
                </div>
            </div>
            <div class="form-group row col-12">
                <label for="merchant_key" class="col-md-4 text-right col-form-label">Tutar
                    :</label>
                <div class="col-md-6">
                    {{ $payment->amount }}
                    @if($payment->currency == 949 )
                        ₺ ( TÜRK LİRASI )
                    @elseif($payment->currency == 840 )
                        $ ( DOLAR )
                    @elseif ($payment->currency == 978)
                        € ( EURO )
                    @else
                        Para Birimi Bilinmiyor!
                    @endif
                </div>
            </div>
            <div class="form-group row col-12">
                <label for="merchant_key" class="col-md-4 text-right col-form-label">Ödeme Yapılan Hesap
                    :</label>
                <div class="col-md-6">
                    {{ $payment->bank }}

                </div>
            </div>
            <div class="form-group row col-12">
                <label for="merchant_key" class="col-md-4 text-right col-form-label">Durumu
                    :</label>
                <div class="col-md-6">
                    @if($payment->status == 1)
                        <span class="badge badge-success">Ödeme Yapıldı</span><br/>
                        <small>Ödeme İşlemi Banka Tarafından Onaylanmıştır. Banka Hesabını Yukarıdaki Sipariş No veya
                            Banka İşlem No ile takip edebilirsiniz.
                        </small>
                    @elseif($payment->status == 2)
                        <span class="badge badge-alert">Ödeme Yapılamadı!</span><br/>
                        <small>Ödeme İşlemi Başlatılmış Fakat Banka Ödemeyi alamamış Kart bilgileri veya diğer ödeme
                            sorunlarından kaynaklanabilir.
                        </small>
                    @else
                        <span class="badge badge-alert">İşlem Başarısız</span><br/>
                        <small>Ödeme Ekranında veya daha öncesinde iptal edilen veya kapatılan işlemler
                        </small>
                    @endif

                </div>
            </div>
        </div>


    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#payment"]').attr('aria-expanded', 'true');
            $('#payment').addClass('show')
        });
    </script>
@endsection