@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Sanal Pos - Gelen Ödemeler</h1>
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 10%;">İşlem No</th>
                    <th style="width: 10%;">Banka İşlem No</th>
                    <th style="width: 10%;">Ad Soyad</th>
                    <th style="width: 10%;">Telefon</th>
                    <th style="width: 10%;">Tutar</th>
                    <th style="width: 10%;">Ödenen Hesap</th>
                    <th style="width: 10%;">Durumu</th>
                    <th style="width: 10%;">İşlemler</th>
                </tr>
                </thead>
                <tbody id="pagelist">
                @if(!empty($payments) && count($payments) > 0)
                    @foreach($payments as $payment)
                        <tr>
                            <td class="text-center">
                                {{ $payment->order_id }}
                            </td>
                            <td class="text-center">
                                {{ $payment->transaction_id }}
                            </td>
                            <td class="text-center">
                                {{ $payment->name }}
                            </td>
                            <td class="text-center">
                                {{ $payment->phone }}
                            </td>
                            <td class="text-center">
                                {{ $payment->amount }}
                                @if ($payment->currency == 949)
                                    ₺ (TÜRK LİRASI)
                                @elseif($payment->currency == 840)
                                    $ (DOLAR)
                                @elseif($payment->currency == 978)
                                    $ (EURO)
                                @else
                                    Tanımlı Olmayan Para Birimi
                                @endif
                            </td>
                            <td>
                                {{ $payment->bank }}
                            </td>
                            <td>
                                @if($payment->status == 0)
                                    Ödeme Yapılmamış
                                @elseif($payment->status == 1)
                                    Ödeme Alınmış
                                @elseif($payment->status == 2)
                                    Ödeme Sırasında Hata
                                @else
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.payment.show',$payment->payment_id) }}"
                                   class="btn btn-info"><i class="fa fa-eye"></i> İncele</a>
                                <button class="btn btn-danger" onclick="confirmDelete({{ $payment->payment_id }})" type="button"><i
                                            class="fa fa-trash"></i></button>
                            </td>
                        </tr>
                    @endforeach
                @endif
                </tbody>
            </table>
        </div>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#payment"]').attr('aria-expanded', 'true');
            $('#payment').addClass('show')
        });

        function confirmDelete(id) {
            swal({
                title: 'Emin misiniz',
                text: "Ödeme Bildirimini Silmek Üzerisiniz.",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Evet Sil',
                cancelButtonText: 'Hayır Silme'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        type: "POST",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('adtrpanel.payment.delete')  }}",
                        data: 'payment_id=' + id,
                        dataType: "text",
                        cache: false,
                        success: function (sonuc) {
                            location.reload();
                        },
                        error: function (xhr, status, error) {
                            alert(xhr.responseText);
                        }
                    });
                } else {
                    return false;
                }
            })
        }
    </script>
@endsection