@php
    $appointments = \App\Models\Randevu::where('status',0)->get()->count();
    $contacts = \App\Models\Contact::all()->count();
@endphp

<header class="d-none d-lg-block d-sm-none">
    <nav class="navbar navbar-expand navbar-dark bg-primary">
        <div class="navbar-collapse collapse">
            @if(isset($anasayfa) && $anasayfa)
                <ul class="tabs list-unstyled" data-tabgroup="first-tab-group">
                    <li><a href="#tabReports" class="active"><img class="tab-icon" src="/admin/img/header/tab/sepetpazarlama.svg">
                            RAPORLAR </a></li>
                    <li><a href="#tabTraffic"><img class="tab-icon" src="/admin/img/header/tab/trafikgozlem.svg"> TRAFİK GÖZLEM </a>
                    </li>
                    <li><a href="#tabTransformation"><img class="tab-icon" src="/admin/img/header/tab/donusumler.svg"> DÖNÜŞÜMLER </a>
                    </li>
                    <li><a href="#tabMarketing"><img class="tab-icon" src="/admin/img/header/tab/sepetpazarlama.svg"> PAZARLAMA </a>
                    </li>
                </ul>
            @endif
            <ul class="navbar-nav ml-auto">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle unread-link" href="#" id="userNotifications" data-toggle="dropdown">
                        <img src="/admin/img/header/notification.png">
                        <span class="unread-count">{{ (int)$appointments + (int) $contacts }}</span>
                    </a>
                        <div class="dropdown-menu dropdown-menu-right" style="width: 200px" aria-labelledby="userNotifications">

                            <ul class="notifications">
                                @if( $appointments > 0 )
                                    <li>
                                        <a href="{{ route('adtrpanel.appointments') }}">
                                            {{ $appointments }} Yeni Randevu
                                        </a>
                                    </li>
                                @endif
                                @if( $contacts > 0 )
                                    <li>
                                        <a href="{{ route('adtrpanel.contact') }}">
                                            {{ $contacts }}  Yeni İletişim Talebi
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </div>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="userArea" data-toggle="dropdown">
                        <img src="{{ \Auth::guard('adtrpanel')->user()->detail->avatar }}" class="user-avatar"><span class="header-label"><strong>{{ \Auth::guard('adtrpanel')->user()->name }}</strong></span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="userArea">
                        <a class="dropdown-item" href="#">Hesabım</a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="{{ route('adtrpanel.logout') }}">Oturumu Kapat</a>
                    </div>
                </li>
                <li class="nav-item home-link">
                    <a href="{{ route('anasayfa') }}" target="_blank"><img src="/admin/img/header/home.png" alt="Siteye git" title="Siteye git"></a>
                </li>
            </ul>
        </div>
    </nav>
</header>