@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="@if(isset($page)) {{ route('adtrpanel.pages.save', $page[0]->page_id) }} @else {{ route('adtrpanel.pages.save') }} @endif" enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> {{ trans('admin.save') }}</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">{{ trans('admin.general_infos') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#meta_info">{{ trans('admin.meta_infos') }}</a>
                    </li>
                    @if($hook = do_action('adtrpanel.page.nav.after', []))
                        @foreach($hook['return'] as $val)
                            @if(!empty($val))
                                {!! $val !!}
                            @endif
                        @endforeach
                    @endif
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>
                    <option data-toggle="pill" value="#meta_info">{{ trans('admin.meta_infos') }}</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    @section('css')
                        <style>
                            .active {display:block!important;}
                        </style>
                    @endsection
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}">
                                        <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @php $a = 0; @endphp
                    @foreach($languages as $language)
                        @php
                            @$pageX = \App\Models\PageDetail::where('language_id',$language->language_id)->where('page_id',$page[0]->page_id)->first();
                        @endphp
                        <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}" style="display: none;" id="{{$language->language_short_name}}">
                            <div class="form-group row">
                                <label for="page_title" class="col-sm-2 col-form-label">Haber Başlığı <span class=" -input">*</span>
                                </label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control char-textarea" name="page_title[{{$language->language_short_name}}]"   maxlength="100"
                                           data-length=100 id="page_title" placeholder="Makale Başlığı"value="{{ @$pageX->page_title }}"/>
                                    <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="page_content" class="col-sm-2 col-form-label">Sayfa İçeriği <span
                                            class=" -input">*</span></label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" rows="5" id="page_content" name="page_content[{{$language->language_short_name}}]" placeholder="Sayfa İçeriği">{{ @$pageX->page_content }}</textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="status" class="col-sm-2 col-form-label">{{ trans('admin.status') }}</label>
                                <div class="col-sm-6">
                                    <select id="status" class="form-control" name="status[{{$language->language_short_name}}]">
                                        <option value="0" @if(@$pageX->status == 0) selected="selected" @endif>{{ trans('admin.passive') }}</option>
                                        <option value="1" @if(@$pageX->status == 1) selected="selected" @endif>{{ trans('admin.active') }}</option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="rank" class="col-sm-2 col-form-label">{{ trans('admin.rank') }}</label>
                                <div class="col-sm-6">
                                    <input type="text" class="form-control" name="rank[{{$language->language_short_name}}]" id="rank" placeholder="Sayfa sıra Numarası" value="{{ @$pageX->rank }}"/>
                                </div>
                            </div>
                        </div>

                @endforeach
                <!-- Genel Bilgi Bitti -->
                </div>
                <div class="tab-pane" id="meta_info">
                    <!--Meta Bilgileri-->
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}_meta">
                                        <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @php $a = 0; @endphp
                    @foreach($languages as $language)
                        @php
                            @$pageZ = \App\Models\PageDetail::where('language_id',$language->language_id)->where('page_id',$page[0]->page_id)->first();
                        @endphp
                        <div class="tab-pane {{$language->language_default == 1 ? "active" : ""}}" style="display: none;" id="{{$language->language_short_name}}_meta">
                            <!--Meta Bilgileri-->
                            <div class="form-group row">
                                <label for="page_meta_title" class="col-sm-2 col-form-label">{{ trans('admin.meta_title') }}
                                </label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control char-textarea" name="page_meta_title[{{$language->language_short_name}}]"   maxlength="100"
                                           data-length=100 id="page_meta_title" placeholder="Sayfa Meta Başlığı" value="{{ @$pageZ->page_meta_title }}" />
                                    <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="page_meta_description" class="col-sm-2 col-form-label">{{ trans('admin.page_meta_description') }} </label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" rows="5" id="page_meta_description" name="page_meta_description[{{$language->language_short_name}}]" placeholder="Sayfa Meta Açıklaması">{{@$pageZ->page_meta_description}}</textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="page_meta_keywords" class="col-sm-2 col-form-label">{{ trans('admin.meta_keywords') }} </label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" rows="5" id="page_meta_keywords" name="page_meta_keywords[{{$language->language_short_name}}]" placeholder="Sayfa Meta Keywords">{{@$pageZ->page_meta_keywords}}</textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="slug" class="col-sm-2 col-form-label">SAyfa SEO Urlsi <i class="fas fa-question-circle info-circle" data-html="true" data-toggle="tooltip" data-placement="right" title="Yazıya özel url tanımlamak isterseniz bu alanı doldurunuz.<br />Örn: yazi-basligi-ozel-url<br />Boş bırakırsanız yazı başlığı SEO URL ye dönüştürülecektir."></i></label>
                                <div class="col-sm-6">
                                    <input type="hidden" name="original_slug" value="{{ @$pageZ->slug }}">
                                    <input type="text" class="form-control" name="slug[{{$language->language_short_name}}]" id="slug" placeholder="Sayfa SEO Urlsi" value="{{ @$pageZ->slug }}"/>
                                </div>
                            </div>
                            <!--Meta Bilgileri Bitti-->
                        </div>
                    @php $a++; @endphp
                @endforeach
                <!--Meta Bilgileri Bitti-->
                </div>
                @if($content_hook = do_action('adtrpanel.page.content.after', ['page_id' => isset($page[0]->page_id) ? $page[0]->page_id : null]))
                    @foreach($content_hook['return'] as $val)
                        @if(!empty($val))
                            {!! $val !!}
                        @endif
                    @endforeach
                @endif
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#pages"]').attr('aria-expanded', 'true');
            $('#pages').addClass('show')
        });
    </script>
    <script src="/ckeditor/ckeditor.js"></script>
    <script>
        var editorConfig = {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        };
        @foreach($languages as $language)
        CKEDITOR.replace( 'page_content[{{$language->language_short_name}}]',  editorConfig);
        @endforeach

    </script>
@endsection