@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Sayfalar</h1>
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th style="width: 5%;" class="text-center">
                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            <span></span>
                        </label>
                    </th>
                    <th style="width: 45%;"> Sayfa Başlığı</th>
                    <th style="width: 10%;"> Sıralama</th>
                    <th style="width: 5%;"> Durumu</th>
                    <th style="width: 35%;"> İşlemler</th>
                </tr>
                </thead>
                <tbody id="pagelist">
                @if (count($page_list) > 0 )
                    @foreach($page_list as $page)
                        <tr>
                            <td class="text-center">
                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                    <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                                    <span></span>
                                </label>
                            </td>
                            <td>{{ $page->page_title }}</td>
                            <td>{{ $page->rank }}</td>
                            <td>
                                @if($page->status)
                                    <span class="badge badge-success">Aktif</span>
                                @else
                                    <span class="badge badge-danger">Pasif</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('adtrpanel.pages.delete', $page->page_id) }}">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="{{ route('adtrpanel.pages.edit', $page->page_id) }}">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i> Düzenle
                                    </button>
                                </a>
                                @if($page->status)
                                    <a href="{{ route('adtrpanel.pages.deactivated', $page->page_id) }}">
                                        <button class="btn btn-warning btn-sm">
                                            <i class="fas fa-lock"></i> Pasif Et
                                        </button>
                                    </a>
                                @else
                                    <a href="{{ route('adtrpanel.pages.activated', $page->page_id) }}">
                                        <button class="btn btn-dark btn-sm">
                                            <i class="fas fa-lock-open"></i> Aktif Et
                                        </button>
                                    </a>
                                @endif
                                <a href="{{ route('page', $page->slug) }}">
                                    <button class="btn btn-primary btn-sm">
                                        <i class="fa fa-eye"></i> Görüntüle
                                    </button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="4" style="text-align: right;">Seçilileri &nbsp;</td>
                        <td>
                            <select name="islem" onchange="this.form.submit()" class="form-control">
                                <option value="0" selected="selected">Seçiniz</option>
                                <option value="sil">Sil</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="9">
                            {{ $page_list->appends(['aranan' => old('aranan')])->links() }}
                        </td>
                    </tr>
                @else
                    <tr class="odd gradeX">
                        <td colspan="9">Hiçbir sayfa bulunamadı</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#pages"]').attr('aria-expanded', 'true');
            $('#pages').addClass('show')
        });
    </script>
@endsection