@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="{{ route('adtrpanel.siteayarlari.save') }}">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> Kaydet</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_setting">Yeni Ayar Ekle</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_setting">Yeni Ayar Ekle</option>

                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_setting">
                    <div class="form-group row">
                        <label for="setting_type" class="col-sm-2 col-form-label">Ayar Tipi</label>
                        <div class="col-sm-10">
                            <select id="setting_type" class="form-control" name="setting_type">
                                <option value="genel">Genel Ayarlar</option>
                                <option value="social">Sosyal Medya Ayarları</option>
                                <option value="limit">Limit Ayarları</option>
                                <option value="relation">İlişki Ayarları</option>
                                <option value="image">Logo Ayarları</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="setting_name" class="col-sm-2 col-form-label">Ayar Adı <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control char-textarea" name="setting_name" required maxlength="100"
                                   data-length=100 id="setting_name" placeholder="Ayar Adı"  value="" />
                            <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="setting_entry" class="col-sm-2 col-form-label">Ayar Değişkeni <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control char-textarea" name="setting_entry" maxlength="100"
                                   data-length=100 id="setting_entry" placeholder="Ayar Değişkeni"  value="" />
                            <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="serialized" class="col-sm-2 col-form-label">Ayar Türü <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <select id="serialized" class="form-control" name="serialized">
                                <option value='null'>Text Verisi</option>
                                <option value='a:2:{i:1;s:4:"Evet";i:0;s:6:"Hayır";}'>Evet Hayır Seçenekli</option>
                                <option value='a:2:{i:1;s:4:"Evet";i:0;s:6:"Hayır";}'>Açık Kapalı Seçenekli</option>
                                <option value='category'>Kategori Listesi</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#sitesettings"]').attr('aria-expanded', 'true');
            $('#sitesettings').addClass('show')
        });
    </script>
@endsection