@extends('adtrpanel.layouts.master')
@if(isset($menu))
    @section('title','Menü Düzenleme Formu')
    @else
        @section('title','Menü Ekle')
        @endif
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <div class="text-right">
            <div class="actions btn-set">
                <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> {{ trans('admin.back') }}
                    </button></a>
                <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> {{ trans('admin.clean') }}</button>
                @foreach($languages as $language)
                    @if(isset($menu))

                        <button type="button" class="btn btn-success" id="menuEkle{{ $language->language_id }}"><i class="fa fa-plus"></i> {{ trans('admin.add_new') . '['.$language->language_short_name . ']'}}</button>
                    @endif
                @endforeach
            </div>
        </div>
        <hr>
        <!--Masaüstü Sekme Linkleri-->
        <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
            <ul class="nav nav-tabs product-tabs-select">
                <li class="nav-item">
                    <a class="nav-link active" data-toggle="pill" href="#general_info">{{ trans('admin.general_infos') }}</a>
                </li>
                @if(isset($menu))
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#menu_lists">{{ trans('admin.menus') }}</a>
                    </li>
                @endif
            </ul>
        </div>
        <!--Masaüstü Sekme Linkleri Bitti-->

        <!--Mobil Sekme Linkleri-->
        <div class="d-lg-none d-sm-block tabs-mobile">
            <select title="Sekme seçiniz" class="mobile-select">
                <option data-toggle="pill" value="#general_info">{{ trans('admin.general_infos') }}</option>
                @if(isset($menu))
                    <option data-toggle="pill" value="#menu_lists">{{ trans('admin.menus') }}</option>
                @endif
            </select>
        </div>
        <!--Mobil Sekme Linkleri Bitti-->
        <!-- Tab panes -->
        <div class="tab-content">
            <div class="tab-pane active" id="general_info">

                <form method="post" action="@if(isset($menu)) {{ route('adtrpanel.menus.save', $menu->menu_id) }} @else {{ route('adtrpanel.menus.save') }} @endif">
                {{ csrf_field() }}
                <!--Genel Bilgiler-->
                    <div class="form-group row">
                        <label for="menu_name" class="col-sm-2 col-form-label">{{ trans('admin.menu_name') }} <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control char-textarea" name="menu_name" required maxlength="100"
                                   data-length=100 id="menu_name" placeholder="{{ trans('admin.menu_name') }}" @if(isset($menu)) value="{{ $menu->menu_name }}" @endif />
                            <span class="char-count">100 </span> <span class="char-count-label">/ 100</span>
                        </div>
                    </div>
                    <div class="panel-footer">
                        @if(isset($menu))
                            <input type="submit" name="submit" value="{{ trans('admin.save') }}" class="btn btn-success btn-block">
                        @else
                            <input type="submit" name="submit" value="{{ trans('admin.add_new') }}" class="btn btn-success btn-block">
                        @endif
                    </div>
                    <!--Genel Bilgi Bittiker-->
                </form>
            </div>
            @if(isset($menu))
                <div class="tab-pane" id="menu_lists">
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}">
                                        <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @foreach($languages as $language)
                        @php
                            @$articleX = \App\Models\MenuDetail::where('language_id',$language->language_id)->where('menu_id',$menu->menu_id)->first();
                        @endphp
                        <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}" style="display: none;" id="{{$language->language_short_name}}">

                            <form id="menuform-{{ $language->language_id }}" name="menuform-{{ $language->language_id }}" class="menuform" method="post" onsubmit="return false;"><input type="hidden" name="menu_id" value="{{ $menu->menu_id }}"/>
                      <ol class="sortable" data-lang="{{$language->language_id}}">
                                    {!! App\Models\Menu::getMenus($menu->menu_id,0,$language->language_id) !!}
                                </ol>
                            </form>
                            <div class="panel-footer">
                                <input type="submit" name="toArray-{{ $language->language_id }}" value="Menüyü Kaydet" id="toArray-{{$language->language_id}}" data-language_id="{{ $language->language_id }}" class="btn btn-success btn-block">
                            </div>
                        </div>
                    @endforeach
                    @endif
                </div>

        </div>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
    <style type="text/css">
        .active {display: block !important;}
        small 					{ font-size: 90%;}
        small code 				{ font-size: 11px;}
        .placeholder 			{ outline: 1px dashed #4183C4;}
        .mjs-nestedSortable-error { background: #fbe3e4;	border-color: transparent;	}
        ol 						{ margin: 0;	padding: 0;	padding-left: 30px;}
        ol.sortable, ol.sortable ol { margin: 0 0 0 40px;	padding: 0;	list-style-type: none;		}
        ol.sortable 			{ margin: 0;	}
        .sortable li 			{     margin: 5px 0 0 0;
            padding: 0;
            clear: both;
            overflow: hidden;}
        /*.sortable li div  		{ position: relative; overflow: hidden;   border: 1px solid #ddd; padding: 6px;width: 100%;  margin:0 0 5px 0;  cursor: move;  background: #fafafa;		}*/
        .collapse-title{font-weight:700; position: relative; overflow: hidden;   border: 1px solid #ddd; padding: 6px;width: 100%;  cursor: move;  background: #f1f1f1;}
        .collapse-title:hover{background: #E1E1E1;}
        .collapse-content{ position: relative; overflow: hidden;   border: 1px solid #ddd; border-top:0; padding: 6px;width: 100%;  margin:0 0 5px 0;  cursor: move;  background: #fff;}
        .sortable li div span.konum	{ float: left; width: 90px; margin: 4px 0px 0 25px; }
        .sortable li div select { float: left; width: 490px;
            padding: 4px; margin: 0;
            border: 1px solid#ddd;
            outline: 0; }
        .sortable li .fa-arrows { float: left; position: absolute; top: 50px; left: 8px;  }
        .sortable li .disclose 	{ float: right;     margin-right: 10px;}
        .sortable li em 		{ float: left;    margin: 4px 27px 0 25px; font-style: normal; }
        .sortable li em.ikinciem 	{     width: 120px;
            margin: 0;}
        .sortable li.mjs-nestedSortable-branch div { }
        #demo 					{ padding: 0 10px; }
        .sortable li.mjs-nestedSortable-leaf {margin-left:0px !important; }
        .sortable li.mjs-nestedSortable-leaf div { }
        li.mjs-nestedSortable-collapsed.mjs-nestedSortable-hovering div { border-color: #999;	background: #fafafa;}
        .disclose 				{ cursor: pointer;width: 10px;}
        .sortable li.mjs-nestedSortable-collapsed > ol { display: none;	}
        .sortable li.mjs-nestedSortable-branch > div > .disclose {	display: inline-block;}

        p, ol, ul, pre, form 	{ margin-top: 0;margin-bottom: 1em;}
        dl 						{ margin: 0;}
        dd 						{ margin: 0;padding: 0 0 0 1.5em;	}
        code 					{ background: #e5e5e5;}
        input 					{ vertical-align: text-bottom;}
        .notice	 				{ color: #c33;}
        .sortable li .menusil   { cursor: pointer; color: #fff; border: 0; background: #EB1C1C; padding: 2px 9px; margin: 0px 0 0 0; float: right; font-size: 18px;  border-radius: 3px; }
        .sortable li .menusil:hover 	{ background: #CE2323; }
        .nestedinput 			{ width: 490px; border: 1px solid#e8e8e8; background: #fff; padding: 5px;float: left;  outline: 0;  color: #222;    margin: 0 10px 4px 0; }

    </style>
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#menus"]').attr('aria-expanded', 'true');
            $('#menus').addClass('show')
        });
    </script>
    <script src="/admin/js/jquery-1.7.2.min.js"></script>
    <script src="/admin/js/jquery-ui-1.8.16.custom.min.js"></script>
    <script src="/admin/js/jquery.ui.touch-punch.js"></script>
    <script src="/admin/js/jquery.mjs.nestedSortable.js"></script>
    <script type="text/javascript">
        $(document).ready(function(){
            $('ol.sortable').nestedSortable({
                forcePlaceholderSize: true,
                handle: 'div',
                helper:	'clone',
                items: 'li',
                opacity: .6,
                placeholder: 'placeholder',
                revert: 250,
                tabSize: 50,
                tolerance: 'pointer',
                toleranceElement: '> div',
                maxLevels: 2,
                isTree: true,
                expandOnHover: 700,
                startCollapsed: true
            });

        });

        $('.collapse-content').hide()

        var collapseIcon = 'fa-chevron-down';
        var collapseUpIcon = 'fa-chevron-up';

        $('.collapse-title').click(function() {
            if ($(this).find('.disclose i').hasClass(collapseIcon)){
                $(this).find('.disclose i').removeClass(collapseIcon).addClass(collapseUpIcon);
                $(this).closest('li').toggleClass('mjs-nestedSortable-collapsed').toggleClass('mjs-nestedSortable-expanded');
                //$(this).next('.collapse-content').slideToggle(100);
                $(this).next('.cc-opened').slideToggle(100);
            } else if ($(this).find('.disclose i').hasClass(collapseUpIcon)){
                $(this).find('.disclose i').removeClass(collapseUpIcon).addClass(collapseIcon);
                $(this).closest('li').toggleClass('mjs-nestedSortable-collapsed').toggleClass('mjs-nestedSortable-expanded');
            }
        });

        $('.collapse-title').live('click', $(this).next('.collapse-content'), function(){
            $(this).next('.collapse-content').slideToggle(100);
        });
        @foreach($languages as $language)
        $('#toArray-{{$language->language_id}}').click(function(e){
            arraied = $('div#{{$language->language_short_name}} ol.sortable').nestedSortable('toArray', {startDepthCount: 0});
            arraied = JSON.stringify(arraied);
            console.log(arraied);
            $.ajax({
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('adtrpanel.menukaydet') }}",
                data: $("#menuform-{{ $language->language_id }}").serialize()+'&menulist='+arraied+'&language_id='+{{$language->language_id}},
                dataType: "text",
                cache: false,
                success: function(){
                    swal({
                        position: 'top-end',
                        type: 'success',
                        title: 'Menü Başarıyla Kaydedildi..',
                        showConfirmButton: false,
                        timer: 2500
                    })
                },
                error: function(xhr, status, error) {
                    alert(xhr.responseText);
                }
            });
            return false;
        });
        @endforeach

        function dump(arr,level) {
            var dumped_text = "";
            if(!level) level = 0;

            //The padding given at the beginning of the line.
            var level_padding = "";
            for(var j=0;j<level+1;j++) level_padding += "    ";

            if(typeof(arr) == 'object') { //Array/Hashes/Objects
                for(var item in arr) {
                    var value = arr[item];

                    if(typeof(value) == 'object') { //If it is an array,
                        dumped_text += level_padding + "'" + item + "' ...\n";
                        dumped_text += dump(value,level+1);
                    } else {
                        dumped_text += level_padding + "'" + item + "' => \"" + value + "\"\n";
                    }
                }
            } else { //Strings/Chars/Numbers etc.
                dumped_text = "===>"+arr+"<===("+typeof(arr)+")";
            }
            return dumped_text;
        }

        function menuSil(menu_detail_id) {
            $.ajax({
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: '{{ route('adtrpanel.menusil') }}',
                data: 'menu_detail_id=' + menu_detail_id,
                dataType: 'text',
                success: function (cevap) {
                    $('#list_' + menu_detail_id).remove();
                },
                error: function (xhr, status, error) {
                    xhr.responseText;
                }
            });
            return false;
        }

        $(document).ready(function() {

            @foreach($languages as $language)
            $('#menuEkle{{$language->language_id}}').on('click', function() {
                var menu_id = $("input[name=menu_id]").val();
                $.ajax({
                    type: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: '{{ route('adtrpanel.sonmenuid') }}',
                    data: {'menu_id':menu_id,language_id:<?php echo $language->language_id; ?>},
                    dataType: 'json',
                    success: function(cevap){
                        var html = '<li id="list_'+cevap.id+'">' +
                            '<div class="collapse-title">Menü Adı <span class="disclose"><i class="fas fa-chevron-down"></i></span></div>' +
                            '<div class="collapse-content cc-opened"><em class="ikinciem">Menü Adı</em><input type="text" value="'+cevap.baslik+'" name="menu_adi[<?php echo $language->language_short_name; ?>]['+cevap.id+']" class="nestedinput" />' +
                            '<span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Menü Url</em> <input type="text" value="#" name="menu_url[<?php echo $language->language_short_name; ?>]['+cevap.id+']" class="nestedinput" />' +
                            '<span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Özel Css</em> <input type="text" value="" name="menu_css[<?php echo $language->language_short_name; ?>]['+cevap.id+']" class="nestedinput" />' +
                            '<span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">İkon</em> <input type="text" value="" name="menu_ikon[<?php echo $language->language_short_name; ?>]['+cevap.id+']" class="nestedinput" />' +
                            '<span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Konum</em><select name="target[<?php echo $language->language_short_name; ?>]['+cevap.id+']"><option value="_self" selected="selected">Aynı Sayfada Açılsın</option><option value="_blank">Farklı Sayfada Açılsın</option></select><button type="button" class="menusil" onclick="menuSil('+cevap.id+')"><i class="fa fa-trash" aria-hidden="true"></i></button></div>';
                        $('div#{{ $language->language_short_name }} ol.sortable').append(html);
                    },
                    error: function(xhr, status, error) {
                        alert(xhr.responseText);
                    }
                });
                return false;
            });
            @endforeach
        })
    </script>
@endsection
