@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="@if(isset($medical_staff)) {{ route('adtrpanel.kadromuz.save', $medical_staff->medical_staff_id) }} @else {{ route('adtrpanel.kadromuz.save') }} @endif" enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> Kaydet</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">Genel Bilgiler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#translates">Çeviriler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#social_media">Sosyal Medya Bilgileri</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#image">Resim</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">Genel Bilgiler</option>
                    <option data-toggle="pill" value="#translates">Çeviriler</option>
                    <option data-toggle="pill" value="#social_media">Sosyal Medya Bilgileri</option>
                    <option data-toggle="pill" value="#image">Resim</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    <!--Genel Bilgiler-->
                    <div class="form-group row">
                        <label for="page_title" class="col-sm-2 col-form-label">Personel Tipi <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <select id="type" class="form-control" name="type">
                                <option value="doctor" @if(isset($medical_staff) && $medical_staff->type == 'doctor') selected="selected" @endif>Doktor</option>
                                <option value="other" @if(isset($medical_staff) && $medical_staff->status == 'other') selected="selected" @endif>Personel</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="name" class="col-sm-2 col-form-label">Adı</label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" name="name" id="name" placeholder="Adı" @if(isset($medical_staff)) value="{{ $medical_staff->name }}" @endif />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="surname" class="col-sm-2 col-form-label">Soyadı</label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" name="surname" id="surname" placeholder="Soyadı" @if(isset($medical_staff)) value="{{ $medical_staff->surname }}" @endif />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="rank" class="col-sm-2 col-form-label">Sıralama</label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" name="rank" id="rank" placeholder="Sıra Numarası" @if(isset($medical_staff)) value="{{ $medical_staff->rank }}" @endif />
                        </div>
                    </div>
                    <!-- Genel Bilgi Bitti -->
                </div>
                <div class="tab-pane" id="translates">
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}">
                                        <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @section('css')
                        <style>
                            .active {display:block!important;}
                        </style>
                    @endsection
                    @foreach($languages as $language)
                        <div class="tab-pane {{$language->language_default == 1 ? "active show" : ""}}" style="display: none;" id="{{$language->language_short_name}}">
                            <div class="form-group row">
                                <label for="position" class="col-sm-2 col-form-label">Görevi <span
                                            class="required-input">*</span></label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" id="position" name="position[{{$language->language_short_name}}]" placeholder="Görevi" @if(isset($medical_staff)) value="@foreach($medical_staff->medicalStaffDetail->where('language_id', $language->language_id) as $details){{$details->position}}@endforeach" @endif />
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="tab-pane" id="social_media">
                    <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                        <ul class="nav nav-tabs product-tabs-select">
                            @foreach($languages as $language)
                                <li class="nav-item">
                                    <a class="nav-link {{$language->language_default == 1 ? "active show" : ""}}" data-toggle="pill" href="#{{$language->language_short_name}}">
                                        <img class="img-thumbnail rounded mx-auto d-block" src="{{$language->language_image}}" width="50" alt="">
                                        <p style="margin-top: 15px" class="text-center h6">{{ $language->language_details }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @foreach($languages as $language)
                        <div class="tab-pane {{$language->language_default == 1 ? "active" : ""}}" style="display: none;" id="{{$language->language_short_name}}">
                            <div class="form-group row">
                                <label for="position" class="col-sm-2 col-form-label">İnstagram</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" id="instagram" name="instagram[{{$language->language_short_name}}]" placeholder="İnstagram" @if(isset($medical_staff)) value="@foreach($medical_staff->medicalStaffDetail->where('language_id', $language->language_id) as $details){{$details->instagram}}@endforeach" @endif />
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="position" class="col-sm-2 col-form-label">Facebook</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" id="facebook" name="facebook[{{$language->language_short_name}}]" placeholder="Facebook" @if(isset($medical_staff)) value="@foreach($medical_staff->medicalStaffDetail->where('language_id', $language->language_id) as $details){{$details->facebook}}@endforeach" @endif />
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="position" class="col-sm-2 col-form-label">Email</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" id="email" name="email[{{$language->language_short_name}}]" placeholder="Email" @if(isset($medical_staff)) value="@foreach($medical_staff->medicalStaffDetail->where('language_id', $language->language_id) as $details){{$details->email}}@endforeach" @endif />
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="tab-pane" id="image">
                    <!--Resim Bilgileri-->
                    <table class="table table-bordered table-hover">
                        <thead>
                        <tr role="row" class="heading">
                            <th> Resim </th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td class="text-center">
                                <input type="file" name="image" class="form-control"  />
                                <small class="text-muted">250 x 350 piksel olmalıdır.</small>
                                @if(isset($medical_staff))
                                    <img src="{{ $medical_staff->image }}" alt="{{ $medical_staff->name . ' ' . $medical_staff->surname }}" class="img-responsive" />
                                @endif
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <!--Resim Bilgileri Bitti-->
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#medicalstaffs"]').attr('aria-expanded', 'true');
            $('#medicalstaffs').addClass('show')
        });
    </script>
    <script src="/ckeditor/ckeditor.js"></script>
    <script>
        CKEDITOR.replace( 'page_content', {
            filebrowserBrowseUrl: '/ckfinder/ckfinder.html',
            filebrowserUploadUrl: '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'
        } );
    </script>
@endsection